package in.sourceshift.genericmodules.securityutils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import org.apache.commons.codec.binary.Base32;

public class BaseEncoder {

    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int b : bytes) {
            b &= 0xff;
            sb.append(HEXDIGITS[b >> 4]);
            sb.append(HEXDIGITS[b & 15]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String bytearraytoHex(byte[] array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = (array.length * 2) - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        } else {
            return hex;
        }
    }

    public static byte[] hexToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; i++) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte) v;
        }
        return b;
    }

    public static String encodeBase64toString(String string) {
        return encodeBase64toString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeBase64toString(byte[] array) {
        return new String(encodeBase64(array));
    }

    public static byte[] encodeBase64(String string) {
        return encodeBase64((string.getBytes(StandardCharsets.UTF_8)));
    }

    // Core method
    public static byte[] encodeBase64(byte[] array) {
        return Base64.getEncoder().encode(array);
    }

    public static String decodeBase64toString(String string) {
        return decodeBase64toString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64toString(byte[] array) {
        return new String(decodeBase64(array));
    }

    public static byte[] decodeBase64(String string) {
        return decodeBase64(string.getBytes(StandardCharsets.UTF_8));
    }

    // Core method
    public static byte[] decodeBase64(byte[] array) {
        return Base64.getDecoder().decode(array);
    }

    public static String encodeBase32toString(String string) {
        return encodeBase32toString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String encodeBase32toString(byte[] array) {
        return new String(encodeBase32(array));
    }

    public static byte[] encodeBase32(String string) {
        return encodeBase32(string.getBytes(StandardCharsets.UTF_8));
    }

    // Core method
    public static byte[] encodeBase32(byte[] array) {
        Base32 b32 = new Base32();
        return b32.encode(array);
    }

    public static String decodeBase32toString(String string) {
        return decodeBase32toString(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase32toString(byte[] array) {
        return new String(decodeBase32(array));
    }

    public static byte[] decodeBase32(String string) {
        return decodeBase32(string.getBytes(StandardCharsets.UTF_8));
    }

    // Core method
    public static byte[] decodeBase32(byte[] array) {
        Base32 b32 = new Base32();
        return b32.decode(array);
    }
}
