/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.httputils.generic;

import in.sourceshift.genericmodules.commons.StringUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPUtils;
import in.sourceshift.genericmodules.httputils.generic.HttpOperations;
import in.sourceshift.genericmodules.httputils.generic.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCommon {
    private static final Logger log = LoggerFactory.getLogger(HttpCommon.class);
    private HTTPUtils httputils;

    public HttpCommon(HTTPUtils httputils) {
        this.httputils = httputils;
    }

    private Response executeHTTPS() throws HTTPUtilsException {
        InputStream inputStream;
        String msg;
        HttpsURLConnection httpsurlconnection;
        Response res = new Response();
        res.setHttpOperation(this.httputils.getHttpOperation());
        try {
            httpsurlconnection = (HttpsURLConnection)this.httputils.getHttpuri().openConnection();
            SSLSocketFactory sslSocketFactory = HttpCommon.createSslSocketFactory();
            httpsurlconnection.setSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e) {
            String msg2 = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg2, e);
        }
        try {
            if (this.httputils.getRequestHeader() != null && !this.httputils.getRequestHeader().isEmpty()) {
                for (Map.Entry<String, String> entry : this.httputils.getRequestHeader().entrySet()) {
                    httpsurlconnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IllegalStateException e) {
            String msg3 = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg3, e);
        }
        try {
            httpsurlconnection.setRequestMethod(this.httputils.getHttpOperation().toString());
            if (this.httputils.getHttpOperation().equals((Object)HttpOperations.POST)) {
                httpsurlconnection.setDoOutput(true);
                OutputStreamWriter osr = new OutputStreamWriter(httpsurlconnection.getOutputStream());
                if (!StringUtils.isEmpty((CharSequence)this.httputils.getRequestbody())) {
                    osr.write(this.httputils.getRequestbody());
                }
                osr.flush();
                osr.close();
            }
        }
        catch (IOException e) {
            if (this.nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpsurlconnection.disconnect();
                return res;
            }
            msg = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            res.setStatusCode(httpsurlconnection.getResponseCode());
        }
        catch (IOException e) {
            if (this.nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpsurlconnection.disconnect();
                return res;
            }
            msg = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            inputStream = httpsurlconnection.getInputStream();
        }
        catch (IOException e) {
            inputStream = httpsurlconnection.getErrorStream();
            res.setFailure(e);
        }
        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            String msg4 = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg4, e);
        }
        catch (NullPointerException enull) {
            String msg5 = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + enull.getMessage();
            log.trace("No Content : " + msg5);
        }
        res.setResponseData(container.toByteArray());
        res.setResponseHeaders(httpsurlconnection.getHeaderFields());
        httpsurlconnection.disconnect();
        return res;
    }

    private Response executeHTTP() throws HTTPUtilsException {
        InputStream inputStream;
        String msg;
        HttpURLConnection httpurlconnection;
        Response res = new Response();
        res.setHttpOperation(this.httputils.getHttpOperation());
        try {
            httpurlconnection = (HttpURLConnection)this.httputils.getHttpuri().openConnection();
        }
        catch (Exception e) {
            String msg2 = "HTTP Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg2, e);
        }
        try {
            if (this.httputils.getRequestHeader() != null && !this.httputils.getRequestHeader().isEmpty()) {
                for (Map.Entry<String, String> entry : this.httputils.getRequestHeader().entrySet()) {
                    httpurlconnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IllegalStateException e) {
            String msg3 = "HTTP Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg3, e);
        }
        try {
            httpurlconnection.setRequestMethod(this.httputils.getHttpOperation().toString());
            if (this.httputils.getHttpOperation().equals((Object)HttpOperations.POST)) {
                httpurlconnection.setDoOutput(true);
                OutputStreamWriter osr = new OutputStreamWriter(httpurlconnection.getOutputStream());
                if (!StringUtils.isEmpty((CharSequence)this.httputils.getRequestbody())) {
                    osr.write(this.httputils.getRequestbody());
                }
                osr.flush();
                osr.close();
            }
        }
        catch (IOException e) {
            if (this.nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpurlconnection.disconnect();
                return res;
            }
            msg = "HTTP Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            res.setStatusCode(httpurlconnection.getResponseCode());
        }
        catch (IOException e) {
            if (this.nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpurlconnection.disconnect();
                return res;
            }
            msg = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            inputStream = httpurlconnection.getInputStream();
        }
        catch (IOException e) {
            inputStream = httpurlconnection.getErrorStream();
            res.setFailure(e);
        }
        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int read;
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            String msg4 = "HTTP Properties : " + this.httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg4, e);
        }
        catch (NullPointerException enull) {
            String msg5 = "HTTPS Properties : " + this.httputils.toString() + " : Error : " + enull.getMessage();
            log.trace("No Content : " + msg5);
        }
        res.setResponseData(container.toByteArray());
        res.setResponseHeaders(httpurlconnection.getHeaderFields());
        httpurlconnection.disconnect();
        return res;
    }

    private static SSLSocketFactory createSslSocketFactory() throws HTTPUtilsException {
        TrustManager[] byPassTrustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HTTPUtilsException(e);
        }
        try {
            sslContext.init(null, byPassTrustManagers, new SecureRandom());
        }
        catch (KeyManagementException e) {
            throw new HTTPUtilsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public Response execute() throws HTTPUtilsException {
        if (this.httputils.getHttpuri().getProtocol().equals("https")) {
            return this.executeHTTPS();
        }
        if (this.httputils.getHttpuri().getProtocol().equals("http")) {
            return this.executeHTTP();
        }
        throw new HTTPUtilsException("Protocol Not Supportd : " + this.httputils.getHttpuri().getProtocol() + ", URI = [" + this.httputils.getHttpuri() + "]");
    }

    private boolean nonhttpexceptioncheck(Throwable throwable) {
        if (throwable.getMessage().contains("Connection timed out: connect")) {
            return true;
        }
        if (throwable.getMessage().contains("Connection refused: connect")) {
            return true;
        }
        return throwable.getClass().equals(UnknownHostException.class);
    }
}

