/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.httputils.generic;

import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPUtils;
import in.sourceshift.genericmodules.httputils.generic.HttpCommon;
import in.sourceshift.genericmodules.httputils.generic.HttpOperations;
import in.sourceshift.genericmodules.httputils.generic.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HTTPPost
implements HTTPUtils {
    private URL httpuri;
    private String USER_AGENT = "Mozilla/5.0";
    private final HttpOperations HttpOperation = HttpOperations.POST;
    private Map<String, String> requestHeader;
    private String requestBody;

    public HTTPPost() {
    }

    public HTTPPost(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        }
        catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    @Override
    public void setHttpuri(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        }
        catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    public void setUSER_AGENT(String uSER_AGENT) {
        this.USER_AGENT = uSER_AGENT;
    }

    @Override
    public void setRequestHeader(Map<String, String> requestHeader) {
        if (this.requestHeader != null && !this.requestHeader.isEmpty()) {
            this.requestHeader.putAll(requestHeader);
        } else {
            this.requestHeader = requestHeader;
        }
    }

    @Override
    public void setRequestHeader(String requestHeaderKey, String requestHeaderValue) {
        if (this.requestHeader != null && !this.requestHeader.isEmpty()) {
            this.requestHeader.put(requestHeaderKey, requestHeaderValue);
        } else {
            this.requestHeader = new HashMap<String, String>();
            this.requestHeader.put(requestHeaderKey, requestHeaderValue);
        }
    }

    @Override
    public void setRequestBody(String requestBody) throws HTTPUtilsException {
        this.requestBody = requestBody;
    }

    @Override
    public Response execute() throws HTTPUtilsException {
        HttpCommon hc = new HttpCommon(this);
        return hc.execute();
    }

    @Override
    public HttpOperations getHttpOperation() {
        return this.HttpOperation;
    }

    @Override
    public URL getHttpuri() {
        return this.httpuri;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public String getRequestbody() {
        return this.requestBody;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTPPost [httpuri=").append(this.httpuri).append(", USER_AGENT=").append(this.USER_AGENT).append(", HttpOperation=").append((Object)this.HttpOperation).append(", requestHeader=").append(this.requestHeader).append(", requestBody=").append(this.requestBody).append("]");
        return builder.toString();
    }
}

