/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.httputils.generic;

import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPUtils;
import in.sourceshift.genericmodules.httputils.generic.HttpCommon;
import in.sourceshift.genericmodules.httputils.generic.HttpOperations;
import in.sourceshift.genericmodules.httputils.generic.Response;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HTTPGet
implements HTTPUtils {
    private URL httpuri;
    private final HttpOperations HttpOperation = HttpOperations.GET;
    private Map<String, String> requestHeader;

    public HTTPGet(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        }
        catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    public HTTPGet() {
    }

    @Override
    public void setHttpuri(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        }
        catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    @Override
    public void setRequestHeader(Map<String, String> requestHeader) {
        if (this.requestHeader != null && !this.requestHeader.isEmpty()) {
            this.requestHeader.putAll(requestHeader);
        } else {
            this.requestHeader = requestHeader;
        }
    }

    @Override
    public void setRequestHeader(String requestHeaderKey, String requestHeaderValue) {
        if (this.requestHeader != null && !this.requestHeader.isEmpty()) {
            this.requestHeader.put(requestHeaderKey, requestHeaderValue);
        } else {
            this.requestHeader = new HashMap<String, String>();
            this.requestHeader.put(requestHeaderKey, requestHeaderValue);
        }
    }

    @Override
    public Response execute() throws HTTPUtilsException {
        HttpCommon hc = new HttpCommon(this);
        return hc.execute();
    }

    @Override
    public void setRequestBody(String requestBody) throws HTTPUtilsException {
        throw new HTTPUtilsException("Request body not expected in HTTP/GET");
    }

    @Override
    public HttpOperations getHttpOperation() {
        return this.HttpOperation;
    }

    @Override
    public URL getHttpuri() {
        return this.httpuri;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    public String getRequestbody() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTPGet [httpuri=").append(this.httpuri).append(", HttpOperation=").append((Object)this.HttpOperation).append(", requestHeader=").append(this.requestHeader).append("]");
        return builder.toString();
    }
}

