/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.httputils.generic;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPExecuter {
    private static final Logger log = LoggerFactory.getLogger(HTTPExecuter.class);

    private static void installTrustManager(String baseurl) throws HTTPUtilsException {
        if (baseurl.toLowerCase().contains("https")) {
            Security.setProperty("jdk.tls.disabledAlgorithms", "");
            Security.setProperty("jdk.certpath.disabledAlgorithms", "");
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sc, hostnameVerifier);
                CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
                Unirest.config().httpClient((HttpClient)closeableHttpClient);
            }
            catch (Exception e) {
                throw new HTTPUtilsException("Unable to create https trust", e);
            }
        }
    }

    public static HttpResponse<byte[]> doHTTP(String resourceURI, String method, Map<String, String> headers, Map<String, Object> queryMap, Object requestBody) throws HTTPUtilsException {
        byte[] requestBodyBytes = null;
        if (requestBody != null) {
            try {
                requestBodyBytes = requestBody.toString().getBytes(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new HTTPUtilsException("Unable to read request body", e);
            }
        }
        return HTTPExecuter.doHTTP(resourceURI, method, headers, queryMap, requestBodyBytes);
    }

    public static HttpResponse<byte[]> doHTTP(String resourceURI, String method, Map<String, String> headers, Map<String, Object> queryMap, byte[] requestBody) throws HTTPUtilsException {
        log.trace("Http executor details : \nURI : " + resourceURI + "\n Method : " + method + "\n headers \n: " + headers + "\n queryMap \n: " + queryMap + "\n requestBody \n: " + (requestBody != null ? new String(requestBody) : null));
        HTTPExecuter.installTrustManager(resourceURI);
        HttpRequestWithBody httpRequestWithBody = Unirest.request((String)method, (String)resourceURI);
        if (MapUtils.isNotEmpty(headers)) {
            httpRequestWithBody = (HttpRequestWithBody)httpRequestWithBody.headers(headers);
        }
        if (MapUtils.isNotEmpty(queryMap)) {
            httpRequestWithBody = (HttpRequestWithBody)httpRequestWithBody.queryString(queryMap);
        }
        HttpResponse response = requestBody != null ? httpRequestWithBody.body(requestBody).asBytes() : httpRequestWithBody.asBytes();
        log.trace("Http executor response details : \n\n Status : " + response.getStatus() + "\n headers \n: " + response.getHeaders() + "\n requestBody \n: " + new String((byte[])response.getBody()));
        return response;
    }
}

