/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.httputils.generic;

import in.sourceshift.genericmodules.commons.BaseEncoder;
import in.sourceshift.genericmodules.commons.StringUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import in.sourceshift.genericmodules.httputils.generic.HTTPPost;
import in.sourceshift.genericmodules.httputils.generic.Response;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(HTTPAuthUtils.class);
    private static final Pattern patforgetBearerTokenusingClientCredentials = Pattern.compile(".*\"access_token\"\\s*:\\s*\"([^\"]+)\".*");

    public static String getBearerTokenusingClientCredentials(String clientId, String clientSecret, String tokenURI, String scope) throws HTTPUtilsException {
        byte[] Authorization = (clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8);
        Object requestBody = new String("grant_type=client_credentials");
        if (!StringUtils.isEmpty((CharSequence)scope)) {
            requestBody = (String)requestBody + "&scope=" + scope;
        }
        HTTPPost logintrequest = new HTTPPost(tokenURI);
        logintrequest.setRequestBody((String)requestBody);
        logintrequest.setRequestHeader("Authorization", "Basic " + BaseEncoder.encodeBase64toString((byte[])Authorization));
        logintrequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        logintrequest.setRequestHeader("Accept", "application/json");
        Response res = logintrequest.execute();
        Matcher matcher = patforgetBearerTokenusingClientCredentials.matcher(new String(res.getResponseData(), StandardCharsets.UTF_8).trim());
        log.trace("Response for getBearerTokenusingClientCredentials" + new String(res.getResponseData()));
        if (matcher.matches() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        throw new HTTPUtilsException("Unable to get Bearer Token");
    }

    public static boolean isBasicAuthValidated(String basicAUTH, String userName, String Password) throws HTTPUtilsException {
        if (StringUtils.isEmpty((CharSequence)basicAUTH) || StringUtils.isEmpty((CharSequence)userName) || StringUtils.isEmpty((CharSequence)Password)) {
            throw new HTTPUtilsException("Basicauth Sring, or Username or Password can't be empty");
        }
        String basicAUTHregenerate = "Basic " + BaseEncoder.encodeBase64toString((String)(userName + ":" + Password));
        return basicAUTH.equals(basicAUTHregenerate);
    }
}

