package in.sourceshift.genericmodules.httputils.generic;

import java.nio.charset.StandardCharsets;
import java.util.Map;

public class Response {
    private HttpOperations HttpOperation;
    private Map<String, ? extends Iterable<String>> responseHeaders = null;
    private byte[] responseData = new byte[] {};
    private Exception failure = null;
    private int statusCode = 0;

    public Response(Map<String, Iterable<String>> responseHeaders, byte[] responseData, Exception failure, int statusCode) {
        super();
        this.responseHeaders = responseHeaders;
        this.responseData = responseData;
        this.failure = failure;
        this.statusCode = statusCode;
    }

    public Response() {
    }

    public HttpOperations getHttpOperation() {
        return HttpOperation;
    }

    public void setHttpOperation(HttpOperations httpOperation) {
        HttpOperation = httpOperation;
    }

    public Map<String, ? extends Iterable<String>> getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(Map<String, ? extends Iterable<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public byte[] getResponseData() {
        return responseData;
    }

    public void setResponseData(byte[] responseData) {
        this.responseData = responseData;
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData.getBytes(StandardCharsets.UTF_8);
    }

    public Exception getFailure() {
        return failure;
    }

    public void setFailure(Exception failure) {
        this.failure = failure;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    /**
     * @see java.lang.Object#toString() return the contents of the byte[] data as a string.
     */
    @Override
    public String toString() {
        return new String(responseData);
    }
}
