package in.sourceshift.genericmodules.httputils.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import in.sourceshift.genericmodules.commons.StringUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class HttpCommon {
    private HTTPUtils httputils;

    public HttpCommon(HTTPUtils httputils) {

        this.httputils = httputils;

    }

    private Response executeHTTPS() throws HTTPUtilsException {
        Response res = new Response();
        res.setHttpOperation(httputils.getHttpOperation());

        HttpsURLConnection httpsurlconnection;
        try {
            httpsurlconnection = (HttpsURLConnection) httputils.getHttpuri().openConnection();
            SSLSocketFactory sslSocketFactory = createSslSocketFactory();
            httpsurlconnection.setSSLSocketFactory(sslSocketFactory);
        } catch (Exception e) {
            String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            if (!((httputils.getRequestHeader() == null) || httputils.getRequestHeader().isEmpty())) {
                for (Map.Entry<String, String> entry : httputils.getRequestHeader().entrySet()) {
                    httpsurlconnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        } catch (java.lang.IllegalStateException e) {
            String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }

        try {
            httpsurlconnection.setRequestMethod(httputils.getHttpOperation().toString());
            if (httputils.getHttpOperation().equals(HttpOperations.POST)) {
                httpsurlconnection.setDoOutput(true);
                OutputStreamWriter osr = new OutputStreamWriter(httpsurlconnection.getOutputStream());
                if (!StringUtils.isEmpty(httputils.getRequestbody())) {
                    osr.write(httputils.getRequestbody());
                }
                osr.flush();
                osr.close();
            }
        } catch (IOException e) {
            if (nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpsurlconnection.disconnect();
                return res;
            } else {
                String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
                throw new HTTPUtilsException(msg, e);
            }
        }
        try {
            res.setStatusCode(httpsurlconnection.getResponseCode());
        } catch (IOException e) {

            if (nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpsurlconnection.disconnect();
                return res;
            } else {
                String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
                throw new HTTPUtilsException(msg, e);
            }

        }
        InputStream inputStream;
        try {
            inputStream = httpsurlconnection.getInputStream();
        } catch (IOException e) {
            inputStream = httpsurlconnection.getErrorStream();
            res.setFailure(e);
        }

        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read;
        try {
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
        } catch (IOException e) {
            String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        } catch (NullPointerException enull) {
            String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + enull.getMessage();
            log.trace("No Content : " + msg);
        }

        res.setResponseData(container.toByteArray());
        res.setResponseHeaders(httpsurlconnection.getHeaderFields());
        httpsurlconnection.disconnect();
        return res;

    }

    private Response executeHTTP() throws HTTPUtilsException {
        Response res = new Response();
        res.setHttpOperation(httputils.getHttpOperation());

        HttpURLConnection httpurlconnection;
        try {
            httpurlconnection = (HttpURLConnection) httputils.getHttpuri().openConnection();
        } catch (Exception e) {
            String msg = "HTTP Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }
        try {
            if (!((httputils.getRequestHeader() == null) || httputils.getRequestHeader().isEmpty())) {
                for (Map.Entry<String, String> entry : httputils.getRequestHeader().entrySet()) {
                    httpurlconnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        } catch (java.lang.IllegalStateException e) {
            String msg = "HTTP Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        }

        try {
            httpurlconnection.setRequestMethod(httputils.getHttpOperation().toString());
            if (httputils.getHttpOperation().equals(HttpOperations.POST)) {
                httpurlconnection.setDoOutput(true);
                OutputStreamWriter osr = new OutputStreamWriter(httpurlconnection.getOutputStream());
                if (!StringUtils.isEmpty(httputils.getRequestbody())) {
                    osr.write(httputils.getRequestbody());
                }
                osr.flush();
                osr.close();
            }
        } catch (IOException e) {
            if (nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpurlconnection.disconnect();
                return res;
            } else {
                String msg = "HTTP Properties : " + httputils.toString() + " : Error : " + e.getMessage();
                throw new HTTPUtilsException(msg, e);
            }
        }
        try {
            res.setStatusCode(httpurlconnection.getResponseCode());
        } catch (IOException e) {
            if (nonhttpexceptioncheck(e)) {
                res.setFailure(e);
                httpurlconnection.disconnect();
                return res;
            } else {
                String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + e.getMessage();
                throw new HTTPUtilsException(msg, e);
            }
        }

        InputStream inputStream;
        try {
            inputStream = httpurlconnection.getInputStream();
        } catch (IOException e) {
            inputStream = httpurlconnection.getErrorStream();
            res.setFailure(e);
        }

        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read;
        try {
            while ((read = inputStream.read(buf, 0, 1024)) > 0) {
                container.write(buf, 0, read);
            }
        } catch (IOException e) {
            String msg = "HTTP Properties : " + httputils.toString() + " : Error : " + e.getMessage();
            throw new HTTPUtilsException(msg, e);
        } catch (NullPointerException enull) {
            String msg = "HTTPS Properties : " + httputils.toString() + " : Error : " + enull.getMessage();
            log.trace("No Content : " + msg);
        }

        res.setResponseData(container.toByteArray());
        res.setResponseHeaders(httpurlconnection.getHeaderFields());
        httpurlconnection.disconnect();
        return res;

    }

    private static SSLSocketFactory createSslSocketFactory() throws HTTPUtilsException {
        TrustManager[] byPassTrustManagers = new TrustManager[] { new X509TrustManager() {
            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        } };
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
        } catch (NoSuchAlgorithmException e) {
            throw new HTTPUtilsException(e);
        }
        try {
            sslContext.init(null, byPassTrustManagers, new SecureRandom());
        } catch (KeyManagementException e) {
            throw new HTTPUtilsException(e);
        }
        return sslContext.getSocketFactory();
    }

    public Response execute() throws HTTPUtilsException {
        if (httputils.getHttpuri().getProtocol().equals("https")) {
            return executeHTTPS();
        } else if (httputils.getHttpuri().getProtocol().equals("http")) {
            return executeHTTP();
        } else {
            throw new HTTPUtilsException("Protocol Not Supportd : " + httputils.getHttpuri().getProtocol() + ", URI = [" + httputils.getHttpuri() + "]");
        }
    }

    private boolean nonhttpexceptioncheck(Throwable throwable) {
        if (throwable.getMessage().contains("Connection timed out: connect")) {
            return true;
        }
        if (throwable.getMessage().contains("Connection refused: connect")) {
            return true;
        }
        return throwable.getClass().equals(java.net.UnknownHostException.class);
    }

}
