package in.sourceshift.genericmodules.httputils.generic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;

public class HTTPPost implements HTTPUtils {

    private URL httpuri;
    private String USER_AGENT = "Mozilla/5.0";
    private final HttpOperations HttpOperation = HttpOperations.POST;
    private Map<String, String> requestHeader;
    private String requestBody;

    public HTTPPost() {

    }

    public HTTPPost(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        } catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    @Override
    public void setHttpuri(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        } catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    public void setUSER_AGENT(String uSER_AGENT) {
        USER_AGENT = uSER_AGENT;
    }

    @Override
    public void setRequestHeader(Map<String, String> requestHeader) {
        if (!((this.requestHeader == null) || this.requestHeader.isEmpty())) {
            this.requestHeader.putAll(requestHeader);
        } else {
            this.requestHeader = requestHeader;
        }
    }

    @Override
    public void setRequestHeader(String requestHeaderKey, String requestHeaderValue) {
        if (!((requestHeader == null) || requestHeader.isEmpty())) {
            requestHeader.put(requestHeaderKey, requestHeaderValue);
        } else {
            requestHeader = new HashMap<String, String>();
            requestHeader.put(requestHeaderKey, requestHeaderValue);
        }

    }

    @Override
    public void setRequestBody(String requestBody) throws HTTPUtilsException {
        this.requestBody = requestBody;
    }

    @Override
    public Response execute() throws HTTPUtilsException {
        HttpCommon hc = new HttpCommon(this);
        return hc.execute();
    }

    @Override
    public HttpOperations getHttpOperation() {
        return HttpOperation;
    }

    @Override
    public URL getHttpuri() {
        return httpuri;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return requestHeader;
    }

    @Override
    public String getRequestbody() {
        return requestBody;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTPPost [httpuri=").append(httpuri).append(", USER_AGENT=").append(USER_AGENT).append(", HttpOperation=").append(HttpOperation).append(", requestHeader=").append(requestHeader).append(", requestBody=")
                .append(requestBody).append("]");
        return builder.toString();
    }

}
