package in.sourceshift.genericmodules.httputils.generic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;

public class HTTPGet implements HTTPUtils {

    private URL httpuri;
    private final HttpOperations HttpOperation = HttpOperations.GET;
    private Map<String, String> requestHeader;

    public HTTPGet(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        } catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    public HTTPGet() {
    }

    @Override
    public void setHttpuri(String httpuri) throws HTTPUtilsException {
        try {
            this.httpuri = new URL(httpuri);
        } catch (MalformedURLException e) {
            throw new HTTPUtilsException(e);
        }
    }

    @Override
    public void setRequestHeader(Map<String, String> requestHeader) {
        if (!((this.requestHeader == null) || this.requestHeader.isEmpty())) {
            this.requestHeader.putAll(requestHeader);
        } else {
            this.requestHeader = requestHeader;
        }
    }

    @Override
    public void setRequestHeader(String requestHeaderKey, String requestHeaderValue) {
        if (!((requestHeader == null) || requestHeader.isEmpty())) {
            requestHeader.put(requestHeaderKey, requestHeaderValue);
        } else {
            requestHeader = new HashMap<String, String>();
            requestHeader.put(requestHeaderKey, requestHeaderValue);
        }

    }

    @Override
    public Response execute() throws HTTPUtilsException {
        HttpCommon hc = new HttpCommon(this);
        return hc.execute();
    }

    @Override
    public void setRequestBody(String requestBody) throws HTTPUtilsException {
        throw new HTTPUtilsException("Request body not expected in HTTP/GET");

    }

    @Override
    public HttpOperations getHttpOperation() {
        return HttpOperation;
    }

    @Override
    public URL getHttpuri() {
        return httpuri;
    }

    @Override
    public Map<String, String> getRequestHeader() {
        return requestHeader;
    }

    @Override
    public String getRequestbody() {
        return null;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTPGet [httpuri=").append(httpuri).append(", HttpOperation=").append(HttpOperation).append(", requestHeader=").append(requestHeader).append("]");
        return builder.toString();
    }

}
