package in.sourceshift.genericmodules.httputils.generic;

import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

import in.sourceshift.genericmodules.commons.MapUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;

@Slf4j
public class HTTPExecuter {

    @SuppressWarnings("deprecation")
    private static void installTrustManager(String baseurl) throws HTTPUtilsException {

        if (baseurl.toLowerCase().contains("https")) {
            java.security.Security.setProperty("jdk.tls.disabledAlgorithms", "");
            java.security.Security.setProperty("jdk.certpath.disabledAlgorithms", "");
            HostnameVerifier hostnameVerifier = new javax.net.ssl.HostnameVerifier() {
                @Override
                public boolean verify(String hostname, javax.net.ssl.SSLSession sslSession) {
                    return true;
                }
            };
            javax.net.ssl.HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            TrustManager[] trustAllCerts = new TrustManager[] { new X509TrustManager() {
                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            } };
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sc, hostnameVerifier);
                CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory(sslConnectionSocketFactory).build();
                Unirest.config().httpClient(closeableHttpClient);
            } catch (Exception e) {
                throw new HTTPUtilsException("Unable to create https trust", e);
            }
        }
    }

    public static HttpResponse<byte[]> doHTTP(String resourceURI, final String method, Map<String, String> headers, Map<String, Object> queryMap, Object requestBody)
            throws HTTPUtilsException {
        byte[] requestBodyBytes = null;
        if (requestBody != null) {
            try {
                requestBodyBytes = requestBody.toString().getBytes(StandardCharsets.UTF_8.name());
            } catch (UnsupportedEncodingException e) {
                throw new HTTPUtilsException("Unable to read request body", e);
            }
        }
        return doHTTP(resourceURI, method, headers, queryMap, requestBodyBytes);
    }

    public static HttpResponse<byte[]> doHTTP(String resourceURI, final String method, Map<String, String> headers, Map<String, Object> queryMap, byte[] requestBody)
            throws HTTPUtilsException {
        log.trace("Http executor details : \n" + "URI : " + resourceURI + "\n Method : " + method + "\n headers \n: " + headers + "\n queryMap \n: " + queryMap
                + "\n requestBody \n: " + ((requestBody != null) ? new String(requestBody) : null));
        installTrustManager(resourceURI);
        HttpResponse<byte[]> response;

        HttpRequestWithBody httpRequestWithBody = Unirest.request(method, resourceURI);

        if (MapUtils.isNotEmpty(headers)) {
            httpRequestWithBody = httpRequestWithBody.headers(headers);
        }

        if (MapUtils.isNotEmpty(queryMap)) {
            httpRequestWithBody = httpRequestWithBody.queryString(queryMap);
        }

        if (requestBody != null) {
            response = httpRequestWithBody.body(requestBody).asBytes();
        } else {
            response = httpRequestWithBody.asBytes();
        }
        log.trace("Http executor response details : \n" + "\n Status : " + response.getStatus() + "\n headers \n: " + response.getHeaders() + "\n requestBody \n: "
                + new String(response.getBody()));
        return response;
    }
}
