package in.sourceshift.genericmodules.httputils.generic;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import in.sourceshift.genericmodules.commons.BaseEncoder;
import in.sourceshift.genericmodules.commons.StringUtils;
import in.sourceshift.genericmodules.httputils.exception.HTTPUtilsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class HTTPAuthUtils {
    private static final Pattern patforgetBearerTokenusingClientCredentials = Pattern.compile(".*\"access_token\"\\s*:\\s*\"([^\"]+)\".*");

    public HTTPAuthUtils() {
    }

    public static String getBearerTokenusingClientCredentials(final String clientId, final String clientSecret, final String tokenURI, String scope) throws HTTPUtilsException {
        byte[] Authorization = (clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8);
        String requestBody = new String("grant_type=client_credentials");
        if (!StringUtils.isEmpty(scope)) {
            requestBody += "&scope=" + scope;
        }
        HTTPUtils logintrequest = new HTTPPost(tokenURI);
        logintrequest.setRequestBody(requestBody);
        logintrequest.setRequestHeader("Authorization", "Basic " + BaseEncoder.encodeBase64toString(Authorization));
        logintrequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        logintrequest.setRequestHeader("Accept", "application/json");
        Response res = logintrequest.execute();
        Matcher matcher = HTTPAuthUtils.patforgetBearerTokenusingClientCredentials.matcher(new String(res.getResponseData(), StandardCharsets.UTF_8).trim());
        log.trace("Response for getBearerTokenusingClientCredentials" + new String(res.getResponseData()));
        if (matcher.matches() && (matcher.groupCount() > 0)) {
            return matcher.group(1);
        }
        throw new HTTPUtilsException("Unable to get Bearer Token");

    }

    public static boolean isBasicAuthValidated(String basicAUTH, String userName, String Password) throws HTTPUtilsException {

        if (StringUtils.isEmpty(basicAUTH) || StringUtils.isEmpty(userName) || StringUtils.isEmpty(Password)) {
            throw new HTTPUtilsException("Basicauth Sring, or Username or Password can't be empty");
        }

        String basicAUTHregenerate = "Basic " + BaseEncoder.encodeBase64toString(userName + ":" + Password);
        return basicAUTH.equals(basicAUTHregenerate);

    }

}
