/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.commons;

import in.sourceshift.genericmodules.commons.ExceptionUtils;
import in.sourceshift.genericmodules.commons.exception.CommonsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String readFileToString(String filepath) throws CommonsException {
        File file = new File(filepath);
        return FileUtils.readFileToString(file);
    }

    public static String readFileToString(File file) throws CommonsException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new CommonsException(e);
        }
        try {
            String e = FileUtils.readFileToString(is);
            return e;
        }
        catch (Throwable e) {
            throw new CommonsException(e);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }
        }
    }

    public static String readFileToString(Class<?> clazz, String fileurl) throws CommonsException {
        URL defectfile = clazz.getResource(fileurl);
        return FileUtils.readFileToString(defectfile);
    }

    public static String readFileToString(URL defectfile) throws CommonsException {
        InputStream is = null;
        try {
            is = defectfile.openStream();
        }
        catch (IOException e) {
            throw new CommonsException(e);
        }
        try {
            String e = FileUtils.readFileToString(is);
            return e;
        }
        catch (Throwable e) {
            throw new CommonsException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }
        }
    }

    public static String readFileToString(InputStream is) throws CommonsException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            int charint;
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((charint = br.read()) != -1) {
                sb.append((char)charint);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new CommonsException(e);
        }
        finally {
            try {
                br.close();
                isr.close();
            }
            catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }
        }
    }

    public static String getExtension(File filename) {
        return FileUtils.getExtension(filename.getAbsolutePath());
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FileUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static byte[] readfiletobyte(String filepath) {
        File file = new File(filepath);
        return FileUtils.readfiletobyte(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readfiletobyte(File file) {
        FileInputStream fileInputStream = null;
        byte[] bytesArray = null;
        try {
            bytesArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bytesArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return bytesArray;
    }

    public static boolean writeBytesToFileNio(byte[] bFile, String fileDest) {
        try {
            Path path = Paths.get(fileDest, new String[0]);
            Files.write(path, bFile, new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

