/*
 * Decompiled with CFR 0.152.
 */
package in.sourceshift.genericmodules.commons;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {
    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getRootCausewithFullStackTrace(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            sb.append("\t" + traceElement + System.lineSeparator());
        }
        if (throwable.getCause() != null) {
            sb.append(ExceptionUtils.getRootCausewithFullStackTrace(throwable.getCause()));
        }
        return new String(sb);
    }

    public static List<String> getRootCausewithFullStackTraceWithListString(Throwable throwable) {
        ArrayList<String> stacktrace = new ArrayList<String>();
        stacktrace.add("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            stacktrace.add(traceElement.toString());
        }
        if (throwable.getCause() != null) {
            stacktrace.addAll(ExceptionUtils.getRootCausewithFullStackTraceWithListString(throwable.getCause()));
        }
        return stacktrace;
    }

    public static String getRootCausewithFullStackTraceforHTMLPage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp; at " + traceElement + "<br/>");
        }
        if (throwable.getCause() != null) {
            sb.append(ExceptionUtils.getRootCausewithFullStackTraceforHTMLPage(throwable.getCause()));
        }
        return new String(sb);
    }
}

