package in.sourceshift.genericmodules.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import in.sourceshift.genericmodules.commons.exception.CommonsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class Properties extends java.util.Properties {

    private static final long serialVersionUID = 4987418869729597259L;

    public static synchronized Properties loadProperties(String absolutepath) throws CommonsException {
        return Properties.loadProperties(new File(absolutepath));
    }

    public static synchronized Properties loadProperties(File propfile) throws CommonsException {
        InputStream fis = null;
        Properties prop = null;
        try {
            fis = new FileInputStream(propfile);
            prop = loadProperties(fis);
        } catch (FileNotFoundException e) {
            throw new CommonsException(e);
        } finally {
            try {
                fis.close();
            } catch (IOException e) {
                throw new CommonsException(e);
            }
        }
        return prop;
    }

    public static synchronized Properties loadProperties(InputStream fis) throws CommonsException {
        Properties prop = new Properties();
        try {
            prop.load(fis);
        } catch (IOException e) {
            throw new CommonsException(e);
        }
        return prop;
    }

    @Deprecated
    public static Properties load(String absolutepath) {
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(absolutepath);
            prop.load(fis);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            try {
                fis.close();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return prop;
    }

    public synchronized void store(String absolutepath, String comment) throws CommonsException {

        File propfile = new File(absolutepath);
        store(propfile, comment);
    }

    public synchronized void store(File propfile, String comments) throws CommonsException {

        OutputStream output = null;
        try {
            output = new FileOutputStream(propfile);
            store(output, comments);
        } catch (IOException e) {
            throw new CommonsException(e);
        } finally {
            try {
                output.close();
            } catch (IOException e) {
                throw new CommonsException(e);
            }
        }
    }

    @Override
    public synchronized String getProperty(String key) {
        Object oval = super.get(key);
        String sval = (oval instanceof String) ? (String) oval : null;
        String retvalue = ((sval == null) && (defaults != null)) ? defaults.getProperty(key) : sval;

        if (StringUtils.isEmpty(retvalue)) {
            log.trace("No Value found for : " + key);
        } else {
            log.trace("Property loaded : " + key + " = " + retvalue);
        }
        return retvalue;

    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (StringUtils.isEmpty(value)) {
            value = new String();
        }
        return put(key, value);
    }

}
