package in.sourceshift.genericmodules.commons;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class MapUtils {
    private static ObjectMapper mapper;

    public static ObjectMapper getMapperInstance() {
        if (MapUtils.mapper == null) {
            MapUtils.mapper = new ObjectMapper();
        }
        return MapUtils.mapper;
    }

    public static boolean isNotEmpty(final CharSequence cs) {
        return !((cs == null) || (cs.length() == 0));
    }

    public static boolean isNotEmpty(final Map<?, ?> map) {
        return !((map == null) || (map.size() == 0));
    }

    public static Map<String, String> jsonAsMap(JsonNode jsonNode) {
        return MapUtils.getMapperInstance().convertValue(jsonNode, new TypeReference<Map<String, String>>() {
        });
    }

    public static JsonNode mapAsJsonNode(Map<String, String> map) {
        return MapUtils.getMapperInstance().convertValue(map, JsonNode.class);
    }

    public static JsonNode stringAsJsonNode(String jsonString) throws JsonProcessingException {
        return MapUtils.getMapperInstance().readTree(jsonString);
    }

    public static ObjectNode stringAsObjectNode(String jsonString) throws JsonProcessingException {
        return (ObjectNode) MapUtils.stringAsJsonNode(jsonString);
    }

    public static ObjectNode mergeJson(ObjectNode oldJSON, ObjectNode newJSON) {
        if (oldJSON == null) {
            return newJSON;
        }
        if (newJSON == null) {
            return oldJSON;
        }
        return oldJSON.setAll(newJSON);
    }

    public static ObjectNode mergeJson(JsonNode oldJSON, ObjectNode newJSON) {
        if (oldJSON == null) {
            return newJSON;
        }
        if (newJSON == null) {
            return (ObjectNode) oldJSON;
        }
        return ((ObjectNode) oldJSON).setAll(newJSON);
    }

    public static String removeEndStart(String data, String startend) {
        return removeEndStart(data, startend, startend);
    }

    public static String removeEndStart(String data, String start, String end) {
        data = StringUtils.removeEnd(data, end);
        data = StringUtils.removeStart(data, start);
        return data;
    }
}
