package in.sourceshift.genericmodules.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;

import in.sourceshift.genericmodules.commons.exception.CommonsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class JSchSSH {

    public static Session getSSHSession(String host, int port, String user, String pass) throws CommonsException {

        JSch jsch = new JSch();
        Session session = null;

        in.sourceshift.genericmodules.commons.Properties config = new in.sourceshift.genericmodules.commons.Properties();
        config.put("StrictHostKeyChecking", "no");
        try {
            session = jsch.getSession(user, host, port);
        } catch (JSchException e1) {
            throw new CommonsException(e1);
        }
        session.setPassword(pass);
        session.setConfig(config);
        try {
            session.connect();
            log.info("Connected to " + session.getUserName() + "@" + session.getHost() + ":" + session.getPort());
            log.debug("session connected : " + session.getClass().toString());
        } catch (JSchException e) {
            throw new CommonsException(e);
        }
        return session;
    }

    public static String sshexec(String command1, Session session) throws CommonsException {
        String ff = "";

        Channel channel = null;
        try {
            channel = session.openChannel("exec");
        } catch (JSchException e) {
            throw new CommonsException("Unable to open exec channel for " + session.getHost() + ":" + session.getPort(), e);
        }
        ((ChannelExec) channel).setCommand(command1);
        channel.setInputStream(null);
        ((ChannelExec) channel).setErrStream(System.err);

        InputStream in = null;
        try {
            in = channel.getInputStream();
        } catch (IOException e) {
            throw new CommonsException("Unable to get inputstream from exec channel for " + session.getHost() + ":" + session.getPort() + ", Command : " + command1, e);

        }
        try {
            channel.connect();
            log.debug("connected to : " + channel.isConnected());
        } catch (JSchException e) {
            throw new CommonsException("Unable to exec channel for " + session.getHost() + ":" + session.getPort() + ", Command : " + command1, e);
        }
        byte[] tmp = new byte[1024];
        while (true) {
            try {
                while (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i < 0) {
                        break;
                    }
                    log.trace(ff);
                    ff += new String(tmp, 0, i);
                }
            } catch (IOException e) {
                throw new CommonsException("Unable to read input stream for " + session.getHost() + ":" + session.getPort() + ", Command : " + command1 + e.getMessage(), e);
            }
            if (channel.isClosed()) {
                log.trace(ff);
                log.info("exit-status: " + channel.getExitStatus());
                break;
            }
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new CommonsException(e);
            }
        }
        channel.disconnect();
        return ff;

    }

    public static String sftpread(Session session, String path) throws CommonsException {
        String ff = "";
        try {
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp sftpChannel = (ChannelSftp) channel;

            InputStream stream = sftpChannel.get(path);
            try (InputStreamReader isr = new InputStreamReader(stream); BufferedReader br = new BufferedReader(isr)) {
                String line;
                while ((line = br.readLine()) != null) {
                    ff = ff + line;
                    log.trace(line);
                }
            } catch (IOException io) {
                String emsg = "Exception occurred during reading file from SFTP server due to " + io.getMessage();
                throw new CommonsException(emsg, io);
            }
            sftpChannel.exit();
            session.disconnect();
        } catch (JSchException | SftpException e) {
            throw new CommonsException(e);
        }
        return ff;
    }

    public static ArrayList<String> sftpreadline(Session session, String path) throws CommonsException {
        ArrayList<String> ff = new ArrayList<String>();
        InputStream stream = null;
        try {
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp sftpChannel = (ChannelSftp) channel;
            try {
                stream = sftpChannel.get(path);
            } catch (Exception e) {
                throw new CommonsException(e);
            }
            try (InputStreamReader isr = new InputStreamReader(stream); BufferedReader br = new BufferedReader(isr)) {
                String line;
                while ((line = br.readLine()) != null) {
                    ff.add(line);
                }
            } catch (IOException e) {
                throw new CommonsException("Exception occurred during reading file from SFTP server due to " + e.getMessage(), e);
            }
            sftpChannel.exit();
        } catch (JSchException e) {
            throw new CommonsException(e);
        }
        return ff;
    }

}
