package in.sourceshift.genericmodules.commons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import in.sourceshift.genericmodules.commons.exception.CommonsException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FileUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString(EXTENSION_SEPARATOR);
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static String readFileToString(String filepath) throws CommonsException {
        File file = new File(filepath);
        return readFileToString(file);
    }

    public static String readFileToString(File file) throws CommonsException {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
        } catch (FileNotFoundException e) {
            throw new CommonsException(e);
        }
        try {
            return readFileToString(is);
        } catch (Throwable e) {
            throw new CommonsException(e);
        } finally {
            try {
                is.close();
            } catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }

        }

    }

    public static String readFileToString(Class<?> clazz, String fileurl) throws CommonsException {
        URL defectfile = clazz.getResource(fileurl);
        return readFileToString(defectfile);

    }

    public static String readFileToString(URL defectfile) throws CommonsException {
        InputStream is = null;
        try {
            is = defectfile.openStream();
        } catch (IOException e) {
            throw new CommonsException(e);
        }
        try {
            return readFileToString(is);
        } catch (Throwable e) {
            throw new CommonsException(e);
        } finally {
            try {
                is.close();
            } catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }

        }

    }

    public static String readFileToString(InputStream is) throws CommonsException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            int charint;
            StringBuffer sb = new StringBuffer();
            while ((charint = br.read()) != -1) {
                sb.append((char) charint);
            }
            return sb.toString();
        } catch (IOException e) {
            throw new CommonsException(e);
        } finally {
            try {
                br.close();
                isr.close();
            } catch (Throwable e) {
                log.error(e.getMessage());
                log.error(ExceptionUtils.getStackTrace(e));
                log.error("Suppresing this exception");
            }

        }

    }

    public static String getExtension(File filename) {
        return getExtension(filename.getAbsolutePath());
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int index = indexOfExtension(filename);
        if (index == -1) {
            return "";
        } else {
            return filename.substring(index + 1);
        }
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(EXTENSION_SEPARATOR);
        int lastSeparator = indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(UNIX_SEPARATOR);
        int lastWindowsPos = filename.lastIndexOf(WINDOWS_SEPARATOR);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static byte[] readfiletobyte(String filepath) {
        File file = new File(filepath);
        return readfiletobyte(file);
    }

    public static byte[] readfiletobyte(File file) {
        FileInputStream fileInputStream = null;
        byte[] bytesArray = null;
        try {

            bytesArray = new byte[(int) file.length()];

            // read file into bytes[]
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bytesArray);

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }
        return bytesArray;
    }

    public static boolean writeBytesToFileNio(byte[] bFile, String fileDest) {

        try {
            Path path = Paths.get(fileDest);
            Files.write(path, bFile);
            return true;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }

    }
}
