package in.sourceshift.genericmodules.commons;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ExceptionUtils {

    public static String getStackTrace(final Throwable throwable) {
        final StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String getRootCausewithFullStackTrace(final Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            sb.append("\t" + traceElement + System.lineSeparator());
        }
        if (throwable.getCause() != null) {
            sb.append(getRootCausewithFullStackTrace(throwable.getCause()));
        }
        return new String(sb);
    }

    public static List<String> getRootCausewithFullStackTraceWithListString(final Throwable throwable) {
        List<String> stacktrace = new ArrayList<String>();
        stacktrace.add("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            stacktrace.add(traceElement.toString());
        }
        if (throwable.getCause() != null) {
            stacktrace.addAll(getRootCausewithFullStackTraceWithListString(throwable.getCause()));
        }
        return stacktrace;
    }

    public static String getRootCausewithFullStackTraceforHTMLPage(final Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("Caused By: " + throwable.getClass().getName() + ": " + throwable.getMessage());
        for (StackTraceElement traceElement : throwable.getStackTrace()) {
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp; at " + traceElement + "<br/>");
        }
        if (throwable.getCause() != null) {
            sb.append(getRootCausewithFullStackTraceforHTMLPage(throwable.getCause()));
        }
        return new String(sb);
    }

}
