package im.qingtui.qbee.open.platform.third.token.filter.config;

import im.qingtui.qbee.open.platform.third.token.filter.QBeeTokenFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author mengtian
 */
@Configuration
public class QBeeAuthFilterConfig implements WebMvcConfigurer {

    @Bean
    public QBeeTokenFilter getTokenFilter(){
        return new QBeeTokenFilter();
    }

    @Bean
    public FilterRegistrationBean setTokenFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(getTokenFilter());
        filterRegistrationBean.addUrlPatterns("/*");
        filterRegistrationBean.setOrder(2);
        return filterRegistrationBean;
    }
}
