package im.qingtui.qbee.open.platform.third.token.filter;

import static im.qingtui.qbee.open.platform.third.token.common.constants.GenerateConstants.SEPARATION_CHARACTER_COMMA;
import static im.qingtui.qbee.open.platfrom.base.common.constants.TokenConstants.TOKEN_HEADER_NAME;

import im.qingtui.qbee.open.platform.third.token.common.constants.SecurityConstants;
import im.qingtui.qbee.open.platform.third.token.common.constants.UrlConstants;
import im.qingtui.qbee.open.platform.third.token.common.exception.QbeeSSOException;
import im.qingtui.qbee.open.platform.third.token.common.utils.JwtUtils;
import im.qingtui.qbee.open.platform.third.token.common.utils.UrlUtils;
import im.qingtui.qbee.open.platform.third.token.model.enums.MatchEnum;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerExceptionResolver;

/**
 * token拦截器
 */
@Slf4j
public class QBeeTokenFilter implements Filter {

    //此处声明异常全局处理
    @Autowired
    private HandlerExceptionResolver handlerExceptionResolver;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {}

    @Override
    public void destroy() {}

    /**
     * 是否需要token验证
     *
     * @param request 请求
     * @return 是否需要token验证
     */
    private boolean needVerify(HttpServletRequest request) {

        String requestURI = request.getRequestURI();
        boolean needVerify = true;

        // 第一优先级匹配
        String conflictFirst = ConfigUtils.getValue(SecurityConstants.CONFLICT_FIRST);
        if (MatchEnum.WHITE.getType().equals(conflictFirst)) {
            needVerify = CollectionUtils.isEmpty(getWhiteURL()) ? true : !UrlUtils.urlInConfigUrl(requestURI, getWhiteURL());
        } else if (MatchEnum.BLACK.getType().equals(conflictFirst)) {
            needVerify = CollectionUtils.isEmpty(getBlackURL()) ? false : UrlUtils.urlInConfigUrl(requestURI, getBlackURL());
        }
        return needVerify;
    }

    /**
     * 获取白名单地址
     *
     * @return 白名单地址列表
     */
    public static List<String> getWhiteURL() {
        // 得到配置的白名单地址
        String expectUrl = ConfigUtils.getValue(SecurityConstants.EXPECT_URL);
        List<String> whiteUrlList = new ArrayList<>();
        whiteUrlList.add(UrlConstants.EXPECT_CHECK_TOKEN);
        whiteUrlList.add(UrlConstants.EXPECT_CHECK_TOKEN_REFRESH);
        whiteUrlList.add(UrlConstants.EXCEPTION_ERROR);
        if (!StringUtils.isEmpty(expectUrl)) {
            whiteUrlList.addAll(new ArrayList<>(Arrays.asList(expectUrl.split(SEPARATION_CHARACTER_COMMA))));
        }
        return whiteUrlList;
    }

    /**
     * 获取黑名单地址
     *
     * @return 黑名单地址列表
     */
    public static List<String> getBlackURL() {
        // 得到配置的黑名单地址
        String needVerifyUrl = ConfigUtils.getValue(SecurityConstants.NEED_VERIFY_URL);
        List<String> blackUrlList = new ArrayList<>();
        if (!StringUtils.isEmpty(needVerifyUrl)) {
            blackUrlList.addAll(new ArrayList<>(Arrays.asList(needVerifyUrl.split(SEPARATION_CHARACTER_COMMA))));
        }
        return blackUrlList;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        // 从请求头或者参数中获取token
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(TOKEN_HEADER_NAME);
        if (this.needVerify(httpServletRequest)) {
            try {
                JwtUtils.verify(token);
                // 设置响应头中的过期时间
                Long expireTime = JwtUtils.getClaimLong(token, SecurityConstants.EXPIRE_TIME_KEY)  * JwtUtils.ONE_SECOND_MILLIS;;
                ((HttpServletResponse)response).addHeader(SecurityConstants.TOKEN_EXPIRE_TIME, String.valueOf(expireTime));
            } catch (QbeeSSOException qbeeSSOException) {
                handlerExceptionResolver.resolveException((HttpServletRequest)request, (HttpServletResponse) response, null, qbeeSSOException);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}