package im.qingtui.qbee.open.platform.third.token.controller;

import im.qingtui.qbee.open.platform.third.token.common.constants.ExceptionConstants;
import im.qingtui.qbee.open.platform.third.token.common.exception.QbeeSSOException;
import im.qingtui.qbee.open.platform.third.token.model.dto.UserInfoDTO;
import im.qingtui.qbee.open.platform.third.token.model.vo.ThirdTokenVO;
import im.qingtui.qbee.open.platform.third.token.service.QBeeTokenService;
import im.qingtui.qbee.open.platform.third.token.common.utils.JwtUtils;
import im.qingtui.qbee.open.platform.third.token.common.constants.SecurityConstants;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseVO;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author mengtian
 */
@RestController
@RequestMapping("qbee/third/token")
@CrossOrigin
public class QBeeThirdTokenController {

    @Autowired
    private QBeeTokenService qBeeTokenService;

    @RequestMapping(value = "check", method = RequestMethod.POST)
    @CrossOrigin
    public BaseVO<ThirdTokenVO> checkQBeeToken(String qbeeToken) {
        return this.getThirdToken(qbeeToken);
    }

    @RequestMapping(value = "refresh", method = RequestMethod.GET)
    @CrossOrigin
    public BaseVO<ThirdTokenVO> freshQBeeToken(String thirdToken) {
        JwtUtils.verify(thirdToken);
        return this.refreshToken(thirdToken);
    }

    /**
     * 得到第三方token
     * @param qBeeToken 轻蜂token
     * @return 第三方token
     */
    private BaseVO<ThirdTokenVO> getThirdToken(String qBeeToken) {

        // 验证轻蜂token
        this.qBeeTokenService.checkQBeeToken(qBeeToken);
        // 得到轻蜂用户信息
        UserInfoDTO userInfoDTO = this.qBeeTokenService.getTokenUserInfo(qBeeToken);
        if (userInfoDTO == null && CollectionUtils.isEmpty(userInfoDTO.getParty())) {
            throw new QbeeSSOException(ExceptionConstants.USER_NOT_EXIST);
        }

        // 生成第三方token
        String employeeId = userInfoDTO.getParty().get(0).getEmployeeId();
        String userId = userInfoDTO.getId();
        long currentTimeMillis = System.currentTimeMillis();
        String configExpireTime = ConfigUtils.getValue(SecurityConstants.EXPIRE_TIME);
        long thirdTokenExpireTime = currentTimeMillis + Long.parseLong(configExpireTime) * JwtUtils.ONE_MINUTES_MILLIS;
        String thirdToken = JwtUtils.sign(employeeId, userId, currentTimeMillis, new Date(thirdTokenExpireTime));
        Long currentTime = JwtUtils.getClaimLong(thirdToken, SecurityConstants.CURRENT_TIME_MILLIS);
        Long expireTime = JwtUtils.getClaimLong(thirdToken, SecurityConstants.EXPIRE_TIME_KEY) * JwtUtils.ONE_SECOND_MILLIS;

        // 设置返回值
        BaseVO<ThirdTokenVO> baseVO = new BaseVO<>();
        baseVO.setData(new ThirdTokenVO(thirdToken,currentTime ,expireTime));
        return baseVO;
    }

    /**
     * 刷新第三方token
     * @param thirdToken 第三方token
     * @return 第三方token
     */
    private BaseVO<ThirdTokenVO> refreshToken(String thirdToken) {

        // 生成第三方token
        String employeeId = JwtUtils.getClaim(thirdToken, SecurityConstants.EMPLOYEE_ID);
        String userId = JwtUtils.getClaim(thirdToken, SecurityConstants.USER_ID);
        long currentTimeMillis = System.currentTimeMillis();
        String configExpireTime = ConfigUtils.getValue(SecurityConstants.EXPIRE_TIME);
        long thirdTokenExpireTime = currentTimeMillis + Long.parseLong(configExpireTime) * JwtUtils.ONE_MINUTES_MILLIS;
        String latestThirdToken = JwtUtils.sign(employeeId, userId, currentTimeMillis, new Date(thirdTokenExpireTime));
        Long expireTime = JwtUtils.getClaimLong(latestThirdToken, SecurityConstants.EXPIRE_TIME_KEY) * JwtUtils.ONE_SECOND_MILLIS;

        // 设置返回值
        BaseVO<ThirdTokenVO> baseVO = new BaseVO<>();
        baseVO.setData(new ThirdTokenVO(latestThirdToken, currentTimeMillis, expireTime));
        return baseVO;
    }
}