package im.qingtui.qbee.open.platform.third.token.common.utils;

import static im.qingtui.qbee.open.platform.third.token.common.constants.GenerateConstants.SEPARATION_CHARACTER_COMMON;
import static im.qingtui.qbee.open.platform.third.token.common.constants.GenerateConstants.SEPARATION_CHARACTER_SLASH;

import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * url工具类
 *
 * @author mengtian
 */
public class UrlUtils {

    /**
     * url是否在相应名单中
     *
     * @param requestUrl 请求的路径
     * @param configUrlList 配置的名单url列表
     * @return 是否为配置名单
     */
    public static boolean urlInConfigUrl(String requestUrl, List<String> configUrlList) {

        boolean urlInUrl = configUrlList.contains(requestUrl);
        if (!urlInUrl) {
            // 再查看通配符匹配（通配符匹配支持/**, /api/**/xxx）
            for (String configUrl : configUrlList) {
                if (configUrl.contains("**") && urlInWildcardUrl(requestUrl, configUrl)) {
                    urlInUrl = true;
                    break;
                }
            }
        } else {
            urlInUrl = true;
        }
        return urlInUrl;
    }

    /**
     * 是否能匹配通配符
     *
     * @param requestUrl 请求地址
     * @param wildcardUrl 通配符地址
     * @return 是否能匹配通配符
     */
    public static boolean urlInWildcardUrl(String requestUrl, String wildcardUrl) {

        boolean urlInWildcardUrl = false;

        // 请求的路径列表
        List<String> requestUrlPathNodeList = new ArrayList<>(Arrays.asList(requestUrl.split(SEPARATION_CHARACTER_SLASH)));
        requestUrlPathNodeList = requestUrlPathNodeList.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());

        // 通配符的路径列表
        List<String> wildcardUrlPathNodeList = new ArrayList<>(Arrays.asList(wildcardUrl.split(SEPARATION_CHARACTER_SLASH)));
        wildcardUrlPathNodeList = wildcardUrlPathNodeList.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());

        // 获取通配符"**"的下标
        int commonIndex = getCommonIndex(wildcardUrlPathNodeList);
        if (commonIndex == 0) {
            urlInWildcardUrl = true;
        } else {
            // 下标前能按顺序找到,下标后也相同则能匹配
            if (commonPrefixEqual(requestUrlPathNodeList, wildcardUrlPathNodeList, commonIndex)
                && commonSuffixEqual(requestUrlPathNodeList, wildcardUrlPathNodeList, commonIndex)) {
                urlInWildcardUrl = true;
            }
        }
        return urlInWildcardUrl;
    }

    /**
     * 计算**前面是否匹配
     *
     * @param requestUrlPathNodeList 请求路径节点列表
     * @param wildcardUrlPathNodeList 通配路径节点列表
     * @param commonIndex 通用**所在下标
     * @return 计算**前面是否匹配
     */
    public static boolean commonPrefixEqual(List<String> requestUrlPathNodeList,
        List<String> wildcardUrlPathNodeList, int commonIndex) {
        boolean commonPrefixEqual = true;
        if ((requestUrlPathNodeList.size() - 1) >= commonIndex - 1) {
            for (int index = 0; index < commonIndex; index++) {
                if (!requestUrlPathNodeList.get(index).equals(wildcardUrlPathNodeList.get(index))) {
                    commonPrefixEqual = false;
                    break;
                }
            }
        } else {
            commonPrefixEqual = false;
        }
        return commonPrefixEqual;
    }

    /**
     * 计算**后面是否匹配
     *
     * @param requestUrlPathNodeList 请求路径节点列表
     * @param wildcardUrlPathNodeList 通配路径节点列表
     * @param commonIndex 通用**所在下标
     * @return 计算**后面是否匹配
     */
    public static boolean commonSuffixEqual(List<String> requestUrlPathNodeList,
        List<String> wildcardUrlPathNodeList, int commonIndex) {
        boolean commonSuffixEqual = true;
        if (requestUrlPathNodeList.size() > commonIndex) {
            if (wildcardUrlPathNodeList.size() > (commonIndex + 1)) {
                // 得到**后面的第一个节点，然后去请求参数找，如果找得到，然后从找到的地方开始对比，如果找不到就匹配不上
                String commonNextUrlNode = wildcardUrlPathNodeList.get(commonIndex + 1);
                int findIndex = getCommonNextUrlNodeIndex(requestUrlPathNodeList, commonNextUrlNode, commonIndex);
                if (findIndex == -1) {
                    commonSuffixEqual = false;
                } else {
                    commonSuffixEqual = getCommonNextUrlNodeEqual(requestUrlPathNodeList,
                        wildcardUrlPathNodeList, commonIndex, findIndex);
                }
            }
        } else if (wildcardUrlPathNodeList.size() > (commonIndex + 1)) {
            commonSuffixEqual = false;
        }
        return commonSuffixEqual;
    }

    /**
     * 寻找通配符**后面的第一个节点是否在请求路径中
     *
     * @param requestUrlPathNodeList 请求路径节点列表
     * @param commonNextUrlNode 通配路径节点下一个节点
     * @param commonIndex 通用**所在下标
     * @return 寻找通配符**后面的第一个节点是否在请求路径中
     */
    public static int getCommonNextUrlNodeIndex(List<String> requestUrlPathNodeList, String commonNextUrlNode, int commonIndex) {
        int findIndex = -1;
        for (int index = commonIndex; index < requestUrlPathNodeList.size(); index++) {
            if (requestUrlPathNodeList.get(index).equals(commonNextUrlNode)) {
                findIndex = index;
                break;
            }
        }
        return findIndex;
    }

    /**
     * 寻找请求的路径从通配符**后面第一个开始对比是否一致
     *
     * @param requestUrlPathNodeList 请求路径节点列表
     * @param wildcardUrlPathNodeList 通配路径节点列表
     * @param commonIndex 通用**所在下标
     * @param requestIndex 请求地址匹配到**后面第一个的路径节点所在下标
     * @return 寻找请求的路径从通配符**后面第一个开始对比是否一致
     */
    public static boolean getCommonNextUrlNodeEqual(List<String> requestUrlPathNodeList,
        List<String> wildcardUrlPathNodeList, int commonIndex, int requestIndex) {

        boolean commonNextUrlNodeEqual = true;
        int maxLength = wildcardUrlPathNodeList.size() > requestUrlPathNodeList.size()
            ? requestUrlPathNodeList.size() : wildcardUrlPathNodeList.size();
        int commonIndexNext = commonIndex + 1;
        int requestIndexNext = requestIndex;
        for (int i = commonIndex; i < maxLength && commonIndexNext < wildcardUrlPathNodeList.size()
            && requestIndexNext < requestUrlPathNodeList.size(); i++) {
            if (i + 1 == maxLength && wildcardUrlPathNodeList.size() > (i + 1)) {
                commonNextUrlNodeEqual = false;
            } else if (!wildcardUrlPathNodeList.get(commonIndexNext)
                .equals(requestUrlPathNodeList.get(requestIndexNext))) {
                commonNextUrlNodeEqual = false;
            }
            commonIndexNext++;
            requestIndexNext++;
        }
        return commonNextUrlNodeEqual;
    }

    /**
     * 获取通配符的下标
     *
     * @param wildcardUrlPathNodeList 通配符url节点列表
     * @return 通配符的下标
     */
    public static int getCommonIndex(List<String> wildcardUrlPathNodeList) {
        int index = 0;
        int finalIndex = -1;
        for (String wildcardUrlNode : wildcardUrlPathNodeList) {
            if (SEPARATION_CHARACTER_COMMON.equals(wildcardUrlNode)) {
                finalIndex = index;
                break;
            }
            index++;
        }
        return finalIndex;
    }
}
