package im.qingtui.qbee.open.platform.third.token.filter.interceptor;

import static im.qingtui.qbee.open.platfrom.base.common.constants.TokenConstants.TOKEN_HEADER_NAME;

import im.qingtui.qbee.open.platform.third.token.common.constants.SecurityConstants;
import im.qingtui.qbee.open.platform.third.token.common.utils.JwtUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

/**
 * token拦截器
 */
@Slf4j
public class TokenInterceptor implements HandlerInterceptor {

    @Autowired
    @Qualifier("handlerExceptionResolver")
    private HandlerExceptionResolver resolver;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {

        try {
            // 从请求头或者参数中获取token
            String token = request.getHeader(TOKEN_HEADER_NAME);

            // 开始校验
            JwtUtils.verify(token);
        } catch (Exception e) {
            resolver.resolveException(request, response, null, e);
            return false;
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {

        // 从请求头或者参数中获取token
        String token = request.getHeader(TOKEN_HEADER_NAME);

        // 设置响应头中的过期时间
        String expireTime = JwtUtils.getClaim(token, SecurityConstants.EXPIRE_TIME_KEY);
        response.setHeader(SecurityConstants.TOKEN_EXPIRE_TIME, expireTime);
    }
}