package im.qingtui.qbee.open.platform.third.token.filter.aop;

import im.qingtui.qbee.open.platfrom.base.common.exception.BaseException;
import im.qingtui.qbee.open.platfrom.base.common.exception.BaseRunTimeException;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseVO;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 轻推通用异常处理拦截器
 *
 * @author bowen
 */
@Slf4j
@RestControllerAdvice
public class BaseExceptionAdvice {

    @ExceptionHandler(BaseException.class)
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleBaseException(BaseException e) {
        log.error("调用接口异常", e);
        return handleCommonBaseException(e.getCode(), e.getErrorMsg(), e.getData(), e.getTemplateVars());
    }

    @ExceptionHandler(BaseRunTimeException.class)
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleBaseRuntimeException(BaseRunTimeException e) {
        log.error("调用接口异常", e);
        return handleCommonBaseException(e.getCode(), e.getErrorMsg(), e.getData(), e.getTemplateVars());
    }

    @ExceptionHandler(Exception.class)
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleException(Exception e) {
        log.error("调用接口异常", e);
        return handleDefaultException();
    }

    @ExceptionHandler(IllegalRequestException.class)
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleIllegalRequestException(Exception e) {
        log.error("调用接口异常", e);
        return handleDefaultException();
    }

    /**
     * 返回 一个 默认 的 -1 异常
     */
    public static BaseVO handleDefaultException() {
        return BaseVO.defaultError();
    }

    /**
     * 处理轻推通用异常
     */
    public static BaseVO handleCommonBaseException(long errorCode, String defaultErrorMsg, Object data, Map<String, String> templateVars) {
        return new BaseVO(errorCode, defaultErrorMsg, data);
    }
}
