/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platform.third.token.filter.interceptor;

import im.qingtui.qbee.open.platform.third.token.common.utils.JwtUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TokenInterceptor.class);
    @Autowired
    @Qualifier(value="handlerExceptionResolver")
    private HandlerExceptionResolver resolver;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        try {
            String token = request.getHeader("Authorization");
            JwtUtils.verify(token);
        }
        catch (Exception e) {
            this.resolver.resolveException(request, response, null, e);
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String token = request.getHeader("Authorization");
        String expireTime = JwtUtils.getClaim(token, "exp");
        response.setHeader("token-expire-time", expireTime);
    }
}

