/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platform.third.token.controller;

import im.qingtui.qbee.open.platform.third.token.common.constants.ExceptionConstants;
import im.qingtui.qbee.open.platform.third.token.common.exception.QbeeSSOException;
import im.qingtui.qbee.open.platform.third.token.common.utils.JwtUtils;
import im.qingtui.qbee.open.platform.third.token.model.dto.UserInfoDTO;
import im.qingtui.qbee.open.platform.third.token.model.vo.ThirdTokenVO;
import im.qingtui.qbee.open.platform.third.token.service.QBeeTokenService;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qbee/third/token"})
@CrossOrigin
public class QBeeThirdTokenController {
    @Autowired
    private QBeeTokenService qBeeTokenService;

    @RequestMapping(value={"check"}, method={RequestMethod.POST})
    @CrossOrigin
    public BaseVO<ThirdTokenVO> checkQBeeToken(String qbeeToken) {
        return this.getThirdToken(qbeeToken);
    }

    @RequestMapping(value={"refresh"}, method={RequestMethod.GET})
    @CrossOrigin
    public BaseVO<ThirdTokenVO> freshQBeeToken(String thirdToken, String qbeeToken) {
        JwtUtils.verify(thirdToken);
        return this.getThirdToken(qbeeToken);
    }

    private BaseVO<ThirdTokenVO> getThirdToken(String qBeeToken) {
        this.qBeeTokenService.checkQBeeToken(qBeeToken);
        UserInfoDTO userInfoDTO = this.qBeeTokenService.getTokenUserInfo(qBeeToken);
        if (userInfoDTO == null && CollectionUtils.isEmpty(userInfoDTO.getParty())) {
            throw new QbeeSSOException(ExceptionConstants.USER_NOT_EXIST);
        }
        String employeeId = userInfoDTO.getParty().get(0).getEmployeeId();
        String userId = userInfoDTO.getId();
        String thirdToken = JwtUtils.signByQBeeToken(employeeId, userId, qBeeToken);
        thirdToken = thirdToken + "." + qBeeToken.split("[.]")[2];
        BaseVO baseVO = new BaseVO();
        baseVO.setData((Object)new ThirdTokenVO(thirdToken));
        return baseVO;
    }
}

