/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platform.third.token.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import im.qingtui.qbee.open.platform.third.token.common.constants.ExceptionConstants;
import im.qingtui.qbee.open.platform.third.token.common.exception.QbeeSSOException;
import im.qingtui.qbee.open.platform.third.token.model.dto.QBeeTokenExpDTO;
import im.qingtui.qbee.open.platfrom.base.common.utils.Base64Utils;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private static final int TOKEN_PARTY_LENGTH = 4;
    private static final long ONE_MINUTES_MILLIS = 60000L;
    private static final long ONE_SECOND_MILLIS = 1000L;

    public static void verify(String token) {
        try {
            String finalToken = JwtUtils.dealToken(token);
            String secret = JwtUtils.getClaim(finalToken, "employeeId") + ConfigUtils.getValue((String)"token.secret");
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            verifier.verify(finalToken);
        }
        catch (Exception e) {
            log.error("token\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            throw new QbeeSSOException(ExceptionConstants.TOKEN_INVALID);
        }
    }

    public static String dealToken(String token) {
        String finalToken;
        if (StringUtils.isEmpty((Object)token)) {
            throw new QbeeSSOException(ExceptionConstants.TOKEN_INVALID);
        }
        String string = finalToken = token.startsWith("Bearer ") ? token.substring("Bearer ".length()) : token;
        if (finalToken.split("[.]").length == 4) {
            finalToken = finalToken.substring(0, finalToken.lastIndexOf("."));
        }
        return finalToken;
    }

    public static String getClaim(String token, String claim) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim(claim).asString();
        }
        catch (JWTDecodeException e) {
            log.error("\u83b7\u53d6token\u53c2\u6570\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String sign(String employeeId, String userId, Long currentTimeMillis, Date expireTime) {
        String secret = employeeId + ConfigUtils.getValue((String)"token.secret");
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("employeeId", employeeId).withClaim("userId", userId).withClaim("currentTimeMillis", currentTimeMillis).withExpiresAt(expireTime).sign(algorithm);
    }

    public static String signByQBeeToken(String employeeId, String userId, String qBeeToken) {
        long qBeeTokenExpireTime;
        String qBeeTokenClaim = qBeeToken.split("[.]")[1];
        QBeeTokenExpDTO qBeeTokenExpDTO = (QBeeTokenExpDTO)JSONObject.parseObject((String)Base64Utils.decode((String)qBeeTokenClaim), QBeeTokenExpDTO.class);
        long currentTimeMillis = System.currentTimeMillis();
        String configExpireTime = ConfigUtils.getValue((String)"expire.time");
        long thirdTokenExpireTime = qBeeTokenExpireTime = qBeeTokenExpDTO.getExp() * 1000L;
        if (!StringUtils.isEmpty((Object)configExpireTime) && Base64Utils.isInteger((String)configExpireTime) && qBeeTokenExpireTime >= currentTimeMillis + Long.parseLong(configExpireTime) * 60000L) {
            thirdTokenExpireTime = currentTimeMillis + Long.parseLong(configExpireTime) * 60000L;
        }
        Date expireTime = new Date(thirdTokenExpireTime);
        return JwtUtils.sign(employeeId, userId, currentTimeMillis, expireTime);
    }
}

