/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platform.third.token.filter.aop;

import im.qingtui.qbee.open.platfrom.base.common.exception.BaseException;
import im.qingtui.qbee.open.platfrom.base.common.exception.BaseRunTimeException;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseVO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class BaseExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(BaseExceptionAdvice.class);

    @ExceptionHandler(value={BaseException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleBaseException(BaseException e) {
        log.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        return BaseExceptionAdvice.handleCommonBaseException(e.getCode(), e.getErrorMsg(), e.getData(), e.getTemplateVars());
    }

    @ExceptionHandler(value={BaseRunTimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleBaseRuntimeException(BaseRunTimeException e) {
        log.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        return BaseExceptionAdvice.handleCommonBaseException(e.getCode(), e.getErrorMsg(), e.getData(), e.getTemplateVars());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleException(Exception e) {
        log.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        return BaseExceptionAdvice.handleDefaultException();
    }

    @ExceptionHandler(value={IllegalRequestException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public BaseVO handleIllegalRequestException(Exception e) {
        log.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        return BaseExceptionAdvice.handleDefaultException();
    }

    public static BaseVO handleDefaultException() {
        return BaseVO.defaultError();
    }

    public static BaseVO handleCommonBaseException(long errorCode, String defaultErrorMsg, Object data, Map<String, String> templateVars) {
        return new BaseVO(errorCode, defaultErrorMsg, data);
    }
}

