package im.qingtui.qbee.open.platform.third.token.service.impl;

import static im.qingtui.qbee.open.platfrom.base.common.constants.ExceptionConstants.SYSTEM_ERROR_CODE;
import static im.qingtui.qbee.open.platfrom.base.common.constants.ExceptionConstants.SYSTEM_ERROR_MESSAGE;
import static im.qingtui.qbee.open.platfrom.base.common.constants.TokenConstants.BASE_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platform.third.token.common.constants.UrlConstants;
import im.qingtui.qbee.open.platform.third.token.common.exception.QbeeSSOException;
import im.qingtui.qbee.open.platform.third.token.model.dto.QBeeTokenDTO;
import im.qingtui.qbee.open.platform.third.token.model.dto.UserInfoDTO;
import im.qingtui.qbee.open.platform.third.token.service.QBeeTokenService;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.model.dto.exception.CodeMsgDTO;
import im.qingtui.qbee.open.platfrom.base.model.dto.http.HttpResponseBodyDTO;
import im.qingtui.qbee.open.platfrom.base.model.dto.response.BaseDTO;
import im.qingtui.qbee.open.platfrom.base.model.enums.RequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.http.HeaderParam;
import im.qingtui.qbee.open.platfrom.base.model.param.http.RequestParam;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Header;
import org.springframework.stereotype.Service;

/**
 * 轻蜂token服务
 *
 * @author mengtian
 */
@Slf4j
@Service
public class QBeeTokenServiceImpl implements QBeeTokenService {

    /**
     * 验证轻蜂token并获取最新token
     *
     * @param qBeeToken 轻蜂token
     */
    public QBeeTokenDTO checkQBeeToken(String qBeeToken) {

        String url = ConfigUtils.getValue(BASE_URL) + UrlConstants.CHECK_QBEE_TOKEN;

        // 请求验证token接口
        HttpResponseBodyDTO httpResponseBodyDTO = requestPost(url, qBeeToken);

        // 得到验证token返回的最新token
        Header[] authorization = httpResponseBodyDTO.getAuthorizationHeaders();
        QBeeTokenDTO qBeeTokenDTO = new QBeeTokenDTO();
        if (authorization != null && authorization.length > 0) {
            qBeeTokenDTO.setToken(authorization[0].getValue());
        }
        return qBeeTokenDTO;
    }

    /**
     * 获取用户信息
     *
     * @param qBeeToken 轻蜂token
     */
    public UserInfoDTO getTokenUserInfo(String qBeeToken) {
        String url = ConfigUtils.getValue(BASE_URL) + UrlConstants.GET_USER_INFO;
        // 请求验证token接口
        HttpResponseBodyDTO httpResponseBodyDTO = requestGet(url, qBeeToken);
        // 转为返回对象
        BaseDTO<UserInfoDTO> userInfoDTOBaseDTO = JSONObject.parseObject(httpResponseBodyDTO.getBody(), new TypeReference<BaseDTO<UserInfoDTO>>() {
        });
        return userInfoDTOBaseDTO.getData();
    }

    /**
     * 发起get请求
     *
     * @param url       当前请求的url地址
     * @param qBeeToken 轻蜂token
     * @return 返回头
     */
    private static HttpResponseBodyDTO requestGet(String url, String qBeeToken) {
        List<RequestParam> requestParamList = new ArrayList<>();
        try {
            requestParamList.addAll(ConfigUtils.beanToRequestParam(new HeaderParam(qBeeToken), RequestTypeEnum.HEADER));
        } catch (Exception e) {
            throw new QbeeSSOException(new CodeMsgDTO(SYSTEM_ERROR_CODE, SYSTEM_ERROR_MESSAGE));
        }
        return HttpClientRequestUtils.getResponse(url, requestParamList.toArray(new RequestParam[requestParamList.size()]));
    }

    /**
     * 发起post请求
     *
     * @param url       当前请求的url地址
     * @param qBeeToken 轻蜂token
     * @return 返回头
     */
    private static HttpResponseBodyDTO requestPost(String url, String qBeeToken) {
        List<RequestParam> requestParamList = new ArrayList<>();
        try {
            requestParamList.addAll(ConfigUtils.beanToRequestParam(new HeaderParam(qBeeToken), RequestTypeEnum.HEADER));
        } catch (Exception e) {
            throw new QbeeSSOException(new CodeMsgDTO(SYSTEM_ERROR_CODE, SYSTEM_ERROR_MESSAGE));
        }
        return HttpClientRequestUtils.postResponse(url, requestParamList.toArray(new RequestParam[requestParamList.size()]));
    }
}