package im.qingtui.qbee.open.platform.third.token.filter.web;

import static im.qingtui.qbee.open.platform.third.token.common.constants.UrlConstants.CROSS_URL;

import im.qingtui.qbee.open.platform.third.token.common.constants.SecurityConstants;
import im.qingtui.qbee.open.platform.third.token.common.constants.UrlConstants;
import im.qingtui.qbee.open.platform.third.token.filter.interceptor.TokenInterceptor;
import im.qingtui.qbee.open.platfrom.base.common.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author mengtian
 */
@Configuration
public class AuthInterceptorConfig implements WebMvcConfigurer {

    @Bean
    public TokenInterceptor tokenInterceptor() {
        return new TokenInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        String expectUrl = ConfigUtils.getValue(SecurityConstants.EXPECT_URL);
        List<String> urlList = new ArrayList<>();
        if (!StringUtils.isEmpty(expectUrl)) {
            urlList.addAll(new ArrayList<>(Arrays.asList(expectUrl.split(","))));
        }
        urlList.add(UrlConstants.EXPECT_CHECK_TOKEN);
        urlList.add(UrlConstants.EXPECT_CHECK_TOKEN_REFRESH);
        urlList.add(UrlConstants.EXCEPTION_ERROR);
        String[] urls = new String[urlList.size()];
        urlList.toArray(urls);
        registry.addInterceptor(tokenInterceptor())
            .addPathPatterns("/**")
            .excludePathPatterns(urls);
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping(CROSS_URL)
            .allowedOrigins("*")
            .allowedMethods("*")
            .allowedHeaders("*")
            .allowCredentials(false).maxAge(3600);
    }
}
