/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.sso.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.sso.common.constants.UrlConstants;
import im.qingtui.qbee.open.platfrom.sso.model.param.sso.GetUserInfoParam;
import im.qingtui.qbee.open.platfrom.sso.model.param.sso.OrgManagerPathListParam;
import im.qingtui.qbee.open.platfrom.sso.model.param.sso.WorkGroupUserTurnParam;
import im.qingtui.qbee.open.platfrom.sso.model.vo.schedule.OrgListVO;
import im.qingtui.qbee.open.platfrom.sso.model.vo.schedule.ScheduleInfo;
import im.qingtui.qbee.open.platfrom.sso.model.vo.schedule.UserSchedule;
import im.qingtui.qbee.open.platfrom.sso.model.vo.sso.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SSOService {
    public static BaseResult checkQBeeToken(String qBeeToken) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.CHECK_Q_BEE_TOKEN_URL, (String)qBeeToken);
        if (200 == baseHttpVO.getCode()) {
            return (BaseResult)JSONObject.parseObject((String)JSONObject.toJSONString((Object)baseHttpVO), BaseResult.class);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseData<User> getUserInfo(String qBeeToken, String userId) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstants.GET_TOKEN_USER_INFO, (String)qBeeToken, (Object)new GetUserInfoParam(userId));
        if (200 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<User>(){}, (Feature[])new Feature[0]));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseData<UserSchedule> getUserInfoAndSchedule(String qBeeToken, String userId) {
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstants.GET_TOKEN_USER_INFO, (String)qBeeToken, (Object)new GetUserInfoParam(userId));
        UserSchedule user = (UserSchedule)HttpClientRequestUtils.converterToData((BaseHttpVO)vo, (TypeReference)new TypeReference<UserSchedule>(){});
        if (user != null) {
            user.setScheduleInfo(SSOService.getScheduleInfo(qBeeToken, userId));
            SSOService.loadOrgPathList(user, qBeeToken);
        }
        return new BaseData((Serializable)user);
    }

    private static ScheduleInfo getScheduleInfo(String qBeeToken, String userId) {
        WorkGroupUserTurnParam param = new WorkGroupUserTurnParam(userId, System.currentTimeMillis());
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstants.SCHEDULE_WORKGROUP_USER_TURN, (String)qBeeToken, (Object)param);
        return (ScheduleInfo)HttpClientRequestUtils.converterToData((BaseHttpVO)vo, (TypeReference)new TypeReference<ScheduleInfo>(){});
    }

    private static void loadOrgPathList(UserSchedule user, String qBeeToken) {
        ArrayList<String> orgIdList = new ArrayList<String>();
        user.getParty().forEach(employeeInfoSchedule -> employeeInfoSchedule.getOrgList().forEach(item -> orgIdList.add(item.getId())));
        Map<String, List<BaseInfo>> map = SSOService.getOrgPathList(qBeeToken, orgIdList);
        user.getParty().forEach(employeeInfoSchedule -> employeeInfoSchedule.getOrgList().forEach(item -> item.setOrgPathList((List)map.get(item.getId()))));
    }

    private static Map<String, List<BaseInfo>> getOrgPathList(String qBeeToken, List<String> orgIdList) {
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstants.ORG_MANAGER_PATH_LIST, (String)qBeeToken, (Object)new OrgManagerPathListParam(orgIdList));
        BaseList listVO = (BaseList)HttpClientRequestUtils.converterToData((BaseHttpVO)vo, (TypeReference)new TypeReference<BaseList<OrgListVO>>(){});
        HashMap<String, List<BaseInfo>> map = new HashMap<String, List<BaseInfo>>();
        if (listVO != null && listVO.getList() != null) {
            listVO.getList().forEach(item -> map.put(item.getOrgId(), item.getPath()));
        }
        return map;
    }
}

