package im.qingtui.qbee.open.platfrom.schedule.service;

import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.LIST_EMPLOYEE_WORK_GROUP_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.LIST_WORK_GROUP_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.SPECIAL_HOLIDAY_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.WORKING_WORK_GROUP_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.WORK_GROUP_EMPLOYEE_LIST_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.WORK_GROUP_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.schedule.model.param.EmployeeOrgWorkGroupParam;
import im.qingtui.qbee.open.platfrom.schedule.model.param.PageBaseParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.BaseVo;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.HolidayVo;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupInfoVo;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupVo;

public class WorkGroupService {

    /**
     * 获取当班班组
     *
     * @param employeeId 员工id
     * @return 当班班组
     */
    public static BaseData<WorkGroupVo> listCurrentWorkGroup(String employeeId) {
        return listCurrentWorkGroup(employeeId, TokenUtils.getToken());
    }

    /**
     * 获取当班班组
     *
     * @param employeeId 员工id
     * @param token 开放平台token
     * @return 当班班组
     */
    public static BaseData<WorkGroupVo> listCurrentWorkGroup(String employeeId, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, WORKING_WORK_GROUP_URL, token, employeeId);
        if (0 == baseHttpVO.getCode()) {
            BaseData<WorkGroupVo> workGroupVoBaseData = JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseData<WorkGroupVo>>(){});
            return workGroupVoBaseData;
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取排班组列表
     *
     * @param param 分页信息
     * @return 班组列表
     */
    public static BaseList<WorkGroupVo> pageWorkGroup(PageBaseParam param) {
        return pageWorkGroup(param, TokenUtils.getToken());
    }

    /**
     * 获取排班组列表
     *
     * @param param 分页信息
     * @param token 开放平台token
     * @return 班组列表
     */
    public static BaseList<WorkGroupVo> pageWorkGroup(PageBaseParam param, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, LIST_WORK_GROUP_URL, token, param);
        if (0 == baseHttpVO.getCode()) {
            BaseList<WorkGroupVo> workGroupVoBaseList = JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<WorkGroupVo>>(){});
            return workGroupVoBaseList;
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取节假日详情
     *
     * @param id 节假日id
     * @return 节假日
     */
    public static BaseData<HolidayVo> getHolidayById(String id) {
        return getHolidayById(id, TokenUtils.getToken());
    }

    /**
     * 获取节假日详情
     *
     * @param id 节假日id
     * @param token 开放平台token
     * @return 节假日
     */
    public static BaseData<HolidayVo> getHolidayById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, SPECIAL_HOLIDAY_URL, token, id);
        if (0 == baseHttpVO.getCode()) {
            BaseData<HolidayVo> holidayVoBaseData = JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseData<HolidayVo>>(){});
            return holidayVoBaseData;
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 通过员工id获取工作组信息
     *
     * @param employeeId 员工id
     * @return 工作组信息
     */
    public static BaseData<WorkGroupInfoVo> getWorkGroupInfoByEmployeeId(String employeeId) {
        return getWorkGroupInfoByEmployeeId(employeeId, TokenUtils.getToken());
    }

    /**
     * 通过员工id获取工作组信息
     *
     * @param employeeId 员工id
     * @param token 开放平台token
     * @return 工作组信息
     */
    public static BaseData<WorkGroupInfoVo> getWorkGroupInfoByEmployeeId(String employeeId, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, LIST_EMPLOYEE_WORK_GROUP_URL, token, employeeId);
        if (0 == baseHttpVO.getCode()) {
            BaseData<WorkGroupInfoVo> workGroupInfoVoBaseData = JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseData<WorkGroupInfoVo>>(){});
            return workGroupInfoVoBaseData;
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 通过班组Id，组织机构Id获取人员列表
     *
     * @param param 组织id与班组id
     * @return 人员列表
     */
    public static BaseList<BaseVo> listEmployeeByOrgIdAndWorkGroupId(EmployeeOrgWorkGroupParam param) {
        return listEmployeeByOrgIdAndWorkGroupId(param, TokenUtils.getToken());
    }

    /**
     * 通过班组Id，组织机构Id获取人员列表
     *
     * @param param 组织id与班组id
     * @param token 开放平台token
     * @return 人员列表
     */
    public static BaseList<BaseVo> listEmployeeByOrgIdAndWorkGroupId(EmployeeOrgWorkGroupParam param, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, WORK_GROUP_EMPLOYEE_LIST_URL, token, param);
        if (0 == baseHttpVO.getCode()) {
            BaseList<BaseVo> baseVoBaseList = JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<BaseVo>>(){});
            return baseVoBaseList;
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 通过班组id获取班组详情
     *
     * @param id 班组id
     * @return 班组详情
     */
    public static WorkGroupVo getWorkGroupDetailById(String id) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(WORK_GROUP_URL, TokenUtils.getToken(), id);
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<WorkGroupVo>(){});
    }
}
