package im.qingtui.qbee.open.platfrom.schedule.service;

import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.GET_SCHEDULE_TURN_LIST_URL;
import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.SCHEDULE_TURN_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.schedule.model.param.PageBaseParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.TurnVo;

/**
 * <p> title: 排班管理的接口 http://rap.dev.qingtui.im/workspace/myWorkspace.do?projectId=196#15576
 * <p> time: 2021/3/19 4:23 下午
 *
 * @author 阳君
 * @version 1.0
 */
public class ScheduleTurnService {

    /**
     * 分页获取班次列表
     *
     * @param param 分页参数
     * @return 班次列表
     */
    public static BaseList<TurnVo> pageScheduleTurnList(PageBaseParam param) {
        return pageScheduleTurnList(param, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<TurnVo> pageScheduleTurnList(PageBaseParam param, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_SCHEDULE_TURN_LIST_URL, token, param);
        return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<TurnVo>>() {
        });
    }

    /**
     * 通过班次 id 获取班次详情
     *
     * @param id 班次id
     * @return 班次信息
     */
    public static TurnVo getScheduleTurnDetail(String id) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(SCHEDULE_TURN_URL, TokenUtils.getToken(), new IdParam(id));
        return HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<TurnVo>() {
        });
    }

}
