package im.qingtui.qbee.open.platfrom.schedule.service;

import static im.qingtui.qbee.open.platfrom.schedule.constants.UrlConstants.WORK_GROUP_LIST_DATE_URL;

import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.schedule.model.param.WorkGroupDateParam;
import im.qingtui.qbee.open.platfrom.schedule.model.vo.WorkGroupListVO;
import java.util.List;
import java.util.Objects;

/**
 * <p> title: 排班服务
 * <p> time: 2021/4/14 11:30 上午
 * @author 阳君
 * @version 1.0.0
 */
public class ScheduleService {

    /**
     * 根据日期查询排班信息
     *
     * @param param 时间戳 毫秒级
     * @return list
     */
    public static List<WorkGroupListVO> getWorkGroupDetailByDate(WorkGroupDateParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(WORK_GROUP_LIST_DATE_URL, TokenUtils.getToken(), param);
        return Objects.requireNonNull(HttpClientRequestUtils.converterToData(baseHttpVO, new TypeReference<BaseList<WorkGroupListVO>>() {
        })).getList();
    }
}
