package im.qingtui.qbee.open.platfrom.schedule.model.vo;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * @author huaan
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class WorkGroupVo implements Serializable {

    /**
     * 工作周期班次id列表
     */
    List<String> circleTurnIds;
    /**
     * 排班组下的员工人数
     */
    Integer countOfMember;
    /**
     * 班组选择的员工id列表
     */
    List<String> employeeIds;
    /**
     * 排班组生效时间
     */
    Long gmtEffect;
    /**
     * 排班组id
     */
    String id;
    /**
     * 排班组名称
     */
    String name;
    /**
     * 普通节假日列表:1-元旦,2-春节,3-清明,4-劳动,5-端午,6-中秋,7-国庆
     */
    List<String> normalHolidays;
    /**
     * 班组选择的组织机构id列表
     */
    List<String> orgIds;
    /**
     * 选择班次id列表
     */
    List<String> selectedIdTurnIds;
    /**
     * 班组选择的特殊人员id列表
     */
    List<String> specialEmployeeIds;
    /**
     * specialHolidayIds
     */
    List<String> specialHolidayIds;
    /**
     * 班次类型:1-固定班次2-循环班次
     */
    Integer turnType;
    /**
     * 工作日列表:1-周一,2-周二,3-周三,4-周四,5-周五,6-周六,7-周日
     */
    List<Integer> workDays;
    /**
     * 当班班次
     */
    String workingTurnId;

}
