package im.qingtui.qbee.open.platfrom.schedule.model.vo;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 班次返回信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class TurnVo implements Serializable {

    /**
     * 班次id
     */
    String id;
    /**
     * 班次名称
     */
    String name;
    /**
     * 班次状态,0-停用,1-启用
     */
    Integer status;
    /**
     * 班次简称
     */
    String shortName;
    /**
     * 班次颜色
     */
    String color;
    /**
     * 班次开始时间
     */
    Long gmtStart;
    /**
     * 班次结束时间
     */
    Long gmtEnd;
    /**
     * 班次创建时间
     */
    Long gmtCreate;
    /**
     * 1-普通班次,2-休息班次
     */
    Integer type;
    /**
     * 休息时间列表
     */
    List<RestVo> gmtRests;


}