/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.qbee.open.platfrom.portal.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseEmployeeIdParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseEmployeeNoParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BasePageParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant;
import im.qingtui.qbee.open.platfrom.portal.model.db.EmployeePositionDO;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AddEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AddEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AttributeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.BatchCrateEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.CreateEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.DeleteEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.DeleteEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeStatusParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeIdListParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeListByEmpCodesParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeListUserIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeNoParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeePageRoleParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeRoleParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeeDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.RegisterEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.org.EmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.takeoffice.BatchTakeOfficeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.takeoffice.DeleteTakeOfficeParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.CreateEmployee;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeAuthInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeBaseInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeOrgInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeePositionInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeRoleInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeUserInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.office.TakeOfficeInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.org.AttributeDetailVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EmployeeService {
    public static BaseData<CreateEmployee> createEmployee(CreateEmployeeParam createEmployeeParam) {
        return EmployeeService.createEmployee(createEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<CreateEmployee> createEmployee(CreateEmployeeParam createEmployeeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.POST, (String)UrlConstant.EMPLOYEE_URL, (String)token, (Object)createEmployeeParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), CreateEmployee.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static void editEmployeeStatus(EditEmployeeStatusParam editEmployeeStatusParam) {
        EmployeeService.editEmployeeStatus(editEmployeeStatusParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployeeStatus(EditEmployeeStatusParam editEmployeeStatusParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.PUT, (String)UrlConstant.EDIT_EMPLOYEE_STATUS_URL, (String)token, (Object)editEmployeeStatusParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void editEmployee(EditEmployeeParam editEmployeeParam) {
        EmployeeService.editEmployee(editEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployee(EditEmployeeParam editEmployeeParam, String token) {
        HttpClientRequestUtils.putRequest((String)UrlConstant.EMPLOYEE_URL, (String)token, (Object)editEmployeeParam);
    }

    public static BaseData<EmployeeInfo> getEmployeeById(String id) {
        return EmployeeService.getEmployeeById(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<EmployeeInfo> getEmployeeById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.EMPLOYEE_URL, (String)token, (Object)new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), EmployeeInfo.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseList<EmployeeOrgInfo> getEmployeeOrgInfoList(String id) {
        return EmployeeService.getEmployeeOrgInfoList(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeOrgInfo> getEmployeeOrgInfoList(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.EMPLOYEE_ORG_URL, (String)token, (Object)new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<EmployeeOrgInfo>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseList<EmployeePositionInfo> getEmployeePositionList(String id) {
        return EmployeeService.getEmployeePositionList(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeePositionInfo> getEmployeePositionList(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.GET_EMPLOYEE_POSITION_BY_ID_URL, (String)token, (Object)new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<EmployeePositionInfo>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static void addEmployeeRole(EmployeeRoleParam param) {
        EmployeeService.addEmployeeRole(Collections.singletonList(param));
    }

    public static void addEmployeeRole(List<EmployeeRoleParam> list) {
        HttpClientRequestUtils.putRequestJson((String)UrlConstant.EMPLOYEE_ROLE_URL, (String)TokenUtils.getToken(), list);
    }

    public static void deleteEmployeeRole(EmployeeRoleParam param) {
        EmployeeService.deleteEmployeeRole(Collections.singletonList(param));
    }

    public static void deleteEmployeeRole(List<EmployeeRoleParam> list) {
        HttpClientRequestUtils.deleteRequestJson((String)UrlConstant.EMPLOYEE_ROLE_URL, (String)TokenUtils.getToken(), list);
    }

    public static BaseList<EmployeeRoleInfo> getEmployeeRoleList(String id) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_ROLE_URL, (String)TokenUtils.getToken(), (Object)new BaseId(id));
        return (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<EmployeeRoleInfo>>(){});
    }

    public static void addEmployeeOrg(AddEmployeeOrgParam addEmployeeOrgParam) {
        EmployeeService.addEmployeeOrg(addEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void addEmployeeOrg(AddEmployeeOrgParam addEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.POST, (String)UrlConstant.EMPLOYEE_ORG_URL, (String)token, (Object)addEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void deleteEmployeeOrg(DeleteEmployeeOrgParam deleteEmployeeOrgParam) {
        EmployeeService.deleteEmployeeOrg(deleteEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void deleteEmployeeOrg(DeleteEmployeeOrgParam deleteEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.DELETE, (String)UrlConstant.EMPLOYEE_ORG_URL, (String)token, (Object)deleteEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void updateEmployeeMasterOrg(EmployeeOrgParam param) {
        HttpClientRequestUtils.putRequest((String)UrlConstant.EMPLOYEE_ORG_URL, (String)TokenUtils.getToken(), (Object)param);
    }

    public static void editEmployeeOrg(EditEmployeeOrgParam editEmployeeOrgParam) {
        EmployeeService.editEmployeeOrg(editEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployeeOrg(EditEmployeeOrgParam editEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.PUT, (String)UrlConstant.EDIT_EMPLOYEE_ORG_STATUS_URL, (String)token, (Object)editEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void addEmployeePosition(AddEmployeePositionParam addEmployeePositionParam) {
        EmployeeService.addEmployeePosition(addEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void addEmployeePosition(AddEmployeePositionParam addEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.POST, (String)UrlConstant.ADD_EMPLOYEE_POSITION_URL, (String)token, (Object)addEmployeePositionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static void deleteEmployeePosition(DeleteEmployeePositionParam deleteEmployeePositionParam) {
        EmployeeService.deleteEmployeePosition(deleteEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void deleteEmployeePosition(DeleteEmployeePositionParam deleteEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.DELETE, (String)UrlConstant.DELETE_EMPLOYEE_POSITION_URL, (String)token, (Object)deleteEmployeePositionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    public static BaseData<EmployeeInfo> getEmployeeInfoByEmployeeNo(String employeeNo) {
        return EmployeeService.getEmployeeInfoByEmployeeNo(employeeNo, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<EmployeeInfo> getEmployeeInfoByEmployeeNo(String employeeNo, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.GET_EMPLOYEE_BY_EMPLOYEE_NO_URL, (String)token, (Object)new BaseEmployeeNoParam(employeeNo));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), EmployeeInfo.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static List<EmployeeBaseInfo> listByEmployeeNo(EmployeeNoParam param) {
        if (CollectionUtils.isEmpty(param.getEmployeeNoList()).booleanValue()) {
            return new ArrayList<EmployeeBaseInfo>();
        }
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_LIST_NO, (String)TokenUtils.getToken(), (Object)param);
        return EmployeeService.converterToListBase(vo);
    }

    public static List<EmployeeInfo> listDetailByEmployeeNo(EmployeeNoParam param) {
        if (CollectionUtils.isEmpty(param.getEmployeeNoList()).booleanValue()) {
            return new ArrayList<EmployeeInfo>();
        }
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_LIST_DETAIL_NO, (String)TokenUtils.getToken(), (Object)param);
        return EmployeeService.converterToListDetail(vo);
    }

    public static BaseList<EmployeeAuthInfo> getEmployeeAuthList(String employeeId) {
        return EmployeeService.getEmployeeAuthList(employeeId, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeAuthInfo> getEmployeeAuthList(String employeeId, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.GET_EMPLOYEE_AUTH_URL, (String)token, (Object)new BaseEmployeeIdParam(employeeId));
        if (0 == baseHttpVO.getCode()) {
            return (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<EmployeeAuthInfo>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseData<CreateEmployee> registerEmployee(RegisterEmployeeParam registerEmployeeParam) {
        return EmployeeService.registerEmployee(registerEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<CreateEmployee> registerEmployee(RegisterEmployeeParam registerEmployeeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.POST, (String)UrlConstant.REGISTER_EMPLOYEE_URL, (String)token, (Object)registerEmployeeParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData((Serializable)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), CreateEmployee.class));
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static void batchCreateEmployee(BatchCrateEmployeeParam batchCrateEmployeeParam) {
        EmployeeService.batchCreateEmployee(batchCrateEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void batchCreateEmployee(BatchCrateEmployeeParam batchCrateEmployeeParam, String token) {
        HttpClientRequestUtils.postRequestJson((String)UrlConstant.EMPLOYEE_BATCH_URL, (String)token, (Object)batchCrateEmployeeParam);
    }

    public static BasePage<EmployeeBaseInfo> pagePartyEmployeeList(BasePageParam basePageParam) {
        return EmployeeService.pagePartyEmployeeList(basePageParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pagePartyEmployeeList(BasePageParam basePageParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.GET_EMPLOYEE_BY_PARTY_URL, (String)token, (Object)basePageParam);
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BasePage<EmployeeBaseInfo>>(){});
    }

    public static BasePage<EmployeeBaseInfo> pageEmployeeListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam) {
        return EmployeeService.pageEmployeeListByOrgId(pageEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.GET_EMPLOYEE_BY_ORG_URL, (String)token, (Object)pageEmployeeOrgParam);
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BasePage<EmployeeBaseInfo>>(){});
    }

    public static BasePage<EmployeeBaseInfo> pageEmployeeAllListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.GET_ALL_EMPLOYEE_BY_ORG_URL, (String)TokenUtils.getToken(), (Object)pageEmployeeOrgParam);
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BasePage<EmployeeBaseInfo>>(){});
    }

    public static BasePage<EmployeeBaseInfo> pageEmployeeListByPositionId(PageEmployeePositionParam pageEmployeePositionParam) {
        return EmployeeService.pageEmployeeListByPositionId(pageEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByPositionId(PageEmployeePositionParam pageEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.GET_EMPLOYEE_BY_POSITION_URL, (String)token, (Object)((Object)pageEmployeePositionParam));
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BasePage<EmployeeBaseInfo>>(){});
    }

    public static BasePage<EmployeeBaseInfo> pageEmployeeListByDimensionId(PageEmployeeDimensionParam pageEmployeeDimensionParam) {
        return EmployeeService.pageEmployeeListByDimensionId(pageEmployeeDimensionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByDimensionId(PageEmployeeDimensionParam pageEmployeeDimensionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.GET_EMPLOYEE_BY_DIMENSION_URL, (String)token, (Object)((Object)pageEmployeeDimensionParam));
        if (0 == baseHttpVO.getCode()) {
            return (BasePage)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BasePage<EmployeeBaseInfo>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static BaseList<EmployeeBaseInfo> employeeListByEmpCodes(EmployeeListByEmpCodesParam employeeListByEmpCodesParam) {
        return EmployeeService.employeeListByEmpCodes(employeeListByEmpCodesParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeBaseInfo> employeeListByEmpCodes(EmployeeListByEmpCodesParam employeeListByEmpCodesParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO((HttpRequestTypeEnum)HttpRequestTypeEnum.GET, (String)UrlConstant.GET_EMPLOYEE_BY_CODE_URL, (String)token, (Object)employeeListByEmpCodesParam);
        if (0 == baseHttpVO.getCode()) {
            return (BaseList)JSONObject.parseObject((String)baseHttpVO.getDataJson().toString(), (TypeReference)new TypeReference<BaseList<EmployeeBaseInfo>>(){}, (Feature[])new Feature[0]);
        }
        throw new IllegalRequestException(new BaseResult(baseHttpVO));
    }

    public static List<EmployeeBaseInfo> listByEmployeeId(EmployeeIdListParam param) {
        return new ArrayList<EmployeeBaseInfo>(BaseList.getData(EmployeeService.listBaseEmployeeInfoByEmpIDList(param)));
    }

    @Deprecated
    public static BaseList<EmployeeUserInfo> listBaseEmployeeInfoByEmpIDList(EmployeeIdListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_BATCH_URL, (String)TokenUtils.getToken(), (Object)param);
        return (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<EmployeeUserInfo>>(){});
    }

    public static BasePage<EmployeeUserInfo> pageLikeName(BasePageParam param) {
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_PAGE_NAME, (String)TokenUtils.getToken(), (Object)param);
        return EmployeeService.converterToPage(vo);
    }

    public static BasePage<EmployeeUserInfo> pageByRole(EmployeePageRoleParam param) {
        if (CollectionUtils.isEmpty(param.getRoleIdList()).booleanValue() && CollectionUtils.isEmpty(param.getRoleCodeList()).booleanValue()) {
            return new BasePage();
        }
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_PAGE_ROLE, (String)TokenUtils.getToken(), (Object)((Object)param));
        return EmployeeService.converterToPage(vo);
    }

    public static List<EmployeeUserInfo> listByUserId(EmployeeListUserIdParam param) {
        if (CollectionUtils.isEmpty(param.getUserIdList()).booleanValue()) {
            return new ArrayList<EmployeeUserInfo>();
        }
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_LIST_USERID, (String)TokenUtils.getToken(), (Object)param);
        return EmployeeService.converterToList(vo);
    }

    private static List<EmployeeUserInfo> converterToList(BaseHttpVO vo) {
        TypeReference<BaseList<EmployeeUserInfo>> type = new TypeReference<BaseList<EmployeeUserInfo>>(){};
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)type);
        return BaseList.getData((BaseList)data);
    }

    private static List<EmployeeBaseInfo> converterToListBase(BaseHttpVO vo) {
        TypeReference<BaseList<EmployeeBaseInfo>> type = new TypeReference<BaseList<EmployeeBaseInfo>>(){};
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)type);
        return BaseList.getData((BaseList)data);
    }

    private static List<EmployeeInfo> converterToListDetail(BaseHttpVO vo) {
        TypeReference<BaseList<EmployeeInfo>> type = new TypeReference<BaseList<EmployeeInfo>>(){};
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)type);
        return BaseList.getData((BaseList)data);
    }

    private static BasePage<EmployeeUserInfo> converterToPage(BaseHttpVO vo) {
        TypeReference<BasePage<EmployeeUserInfo>> type = new TypeReference<BasePage<EmployeeUserInfo>>(){};
        return (BasePage)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)type);
    }

    public static Long getAddPositionGmtTime(EmployeePositionParam param) {
        TypeReference<EmployeePositionDO> type;
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_POSITION_JOIN, (String)TokenUtils.getToken(), (Object)param);
        EmployeePositionDO data = (EmployeePositionDO)((Object)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)(type = new TypeReference<EmployeePositionDO>(){})));
        return data == null ? null : data.getGmtCreate();
    }

    public static List<AttributeDetailVO> listAttribute(String employeeId) {
        TypeReference<BaseList<AttributeDetailVO>> type;
        IdParam param = new IdParam(employeeId);
        BaseHttpVO vo = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_LIST_ATTRIBUTE, (String)TokenUtils.getToken(), (Object)param);
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)vo, (TypeReference)(type = new TypeReference<BaseList<AttributeDetailVO>>(){}));
        return data != null ? data.getList() : new ArrayList();
    }

    public static void updateAttribute(AttributeParam param) {
        if (CollectionUtils.isEmpty(param.getAttributeMap()).booleanValue()) {
            return;
        }
        HttpClientRequestUtils.putRequest((String)UrlConstant.EMPLOYEE_ATTRIBUTE, (String)TokenUtils.getToken(), (Object)param);
    }

    public static List<String> addTakeOfficeByEmpId(BatchTakeOfficeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequestJson((String)UrlConstant.EMPLOYEE_TAKE_OFFICE_URL, (String)TokenUtils.getToken(), (Object)param);
        return ((BaseList)Objects.requireNonNull(HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<String>>(){}))).getList();
    }

    public static void deleteTakeOfficeById(DeleteTakeOfficeParam param) {
        HttpClientRequestUtils.deleteRequest((String)UrlConstant.EMPLOYEE_TAKE_OFFICE_URL, (String)TokenUtils.getToken(), (Object)param);
    }

    public static void updateTakeOfficeByEmpId(BatchTakeOfficeParam param) {
        HttpClientRequestUtils.putRequestJson((String)UrlConstant.EMPLOYEE_TAKE_OFFICE_URL, (String)TokenUtils.getToken(), (Object)param);
    }

    public static List<TakeOfficeInfo> listTakeOfficeByEmpId(EmployeeIdParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_TAKE_OFFICE_URL, (String)TokenUtils.getToken(), (Object)param);
        return ((BaseList)Objects.requireNonNull(HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<TakeOfficeInfo>>(){}))).getList();
    }

    public static List<BaseInfo> listOrgByDimension(EmployeeDimensionParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest((String)UrlConstant.EMPLOYEE_DIMENSION_ORG_URL, (String)TokenUtils.getToken(), (Object)param);
        BaseList data = (BaseList)HttpClientRequestUtils.convertToData((BaseHttpVO)baseHttpVO, (TypeReference)new TypeReference<BaseList<BaseInfo>>(){});
        return BaseList.getData((BaseList)data);
    }
}

