package im.qingtui.qbee.open.platfrom.portal.service;

import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.ADD_EMPLOYEE_POSITION_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.DELETE_EMPLOYEE_POSITION_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EDIT_EMPLOYEE_ORG_STATUS_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EDIT_EMPLOYEE_STATUS_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_ATTRIBUTE;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_BATCH_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_DIMENSION_ORG_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_LIST_ATTRIBUTE;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_LIST_DETAIL_NO;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_LIST_NO;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_LIST_USERID;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_ORG_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_PAGE_NAME;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_PAGE_ROLE;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_POSITION_JOIN;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_ROLE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_TAKE_OFFICE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.EMPLOYEE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_ALL_EMPLOYEE_BY_ORG_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_AUTH_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_CODE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_DIMENSION_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_EMPLOYEE_NO_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_ORG_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_PARTY_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_BY_POSITION_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_EMPLOYEE_POSITION_BY_ID_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.REGISTER_EMPLOYEE_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.CollectionUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseEmployeeIdParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BaseEmployeeNoParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.BasePageParam;
import im.qingtui.qbee.open.platfrom.base.model.param.base.IdParam;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.model.db.EmployeePositionDO;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AddEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AddEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.AttributeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.BatchCrateEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.CreateEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.DeleteEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.DeleteEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EditEmployeeStatusParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeIdListParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeListByEmpCodesParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeListUserIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeNoParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeePageRoleParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeRoleParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeeDimensionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.PageEmployeePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.RegisterEmployeeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.org.EmployeeOrgParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.takeoffice.BatchTakeOfficeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.takeoffice.DeleteTakeOfficeParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.CreateEmployee;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeAuthInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeBaseInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeOrgInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeePositionInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeRoleInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.EmployeeUserInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.office.TakeOfficeInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.org.AttributeDetailVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.val;

/**
 * 员工管理
 *
 * @author shizhen
 */
public class EmployeeService {

    /**
     * 创建员工（不带token,取配置文件的服务号信息获取token）
     *
     * @param createEmployeeParam 创建员工参数
     * @return 创建的员工信息
     */
    public static BaseData<CreateEmployee> createEmployee(CreateEmployeeParam createEmployeeParam) {
        return createEmployee(createEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<CreateEmployee> createEmployee(CreateEmployeeParam createEmployeeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, EMPLOYEE_URL, token, createEmployeeParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), CreateEmployee.class));
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 编辑员工状态（被删除的员工不支持修改状态）（不带token,取配置文件的服务号信息获取token）
     *
     * @param editEmployeeStatusParam 编辑员工状态参数
     */
    public static void editEmployeeStatus(EditEmployeeStatusParam editEmployeeStatusParam) {
        editEmployeeStatus(editEmployeeStatusParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployeeStatus(EditEmployeeStatusParam editEmployeeStatusParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.PUT, EDIT_EMPLOYEE_STATUS_URL, token, editEmployeeStatusParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 编辑员工信息（不带token,取配置文件的服务号信息获取token）
     *
     * @param editEmployeeParam 编辑员工信息参数
     */
    public static void editEmployee(EditEmployeeParam editEmployeeParam) {
        editEmployee(editEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployee(EditEmployeeParam editEmployeeParam, String token) {
        HttpClientRequestUtils.putRequest(EMPLOYEE_URL, token, editEmployeeParam);
    }

    /**
     * 根据员工id获取员工信息（不带token,取配置文件的服务号信息获取token）
     *
     * @param id 员工id
     * @return 查询的员工信息
     */
    public static BaseData<EmployeeInfo> getEmployeeById(String id) {
        return getEmployeeById(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<EmployeeInfo> getEmployeeById(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, EMPLOYEE_URL, token, new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), EmployeeInfo.class));
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取员工组织机构信息
     *
     * @param id 员工id
     * @return 员工所属的组织机构信息列表
     */
    public static BaseList<EmployeeOrgInfo> getEmployeeOrgInfoList(String id) {
        return getEmployeeOrgInfoList(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeOrgInfo> getEmployeeOrgInfoList(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, EMPLOYEE_ORG_URL, token, new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<EmployeeOrgInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 根据员工id获取员工所属的岗位信息列表（不带token,取配置文件的服务号信息获取token）
     *
     * @param id 员工id
     * @return 员工所属的岗位信息列表
     */
    public static BaseList<EmployeePositionInfo> getEmployeePositionList(String id) {
        return getEmployeePositionList(id, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeePositionInfo> getEmployeePositionList(String id, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, GET_EMPLOYEE_POSITION_BY_ID_URL, token, new BaseId(id));
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<EmployeePositionInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 员工添加角色
     *
     * @param param EmployeeRoleParam
     */
    public static void addEmployeeRole(EmployeeRoleParam param) {
        addEmployeeRole(Collections.singletonList(param));
    }

    /**
     * 批量员工添加角色
     *
     * @param list EmployeeRoleParam
     */
    public static void addEmployeeRole(List<EmployeeRoleParam> list) {
        HttpClientRequestUtils.putRequestJson(EMPLOYEE_ROLE_URL, TokenUtils.getToken(), list);
    }

    /**
     * 员工删除角色
     *
     * @param param EmployeeRoleParam
     */
    public static void deleteEmployeeRole(EmployeeRoleParam param) {
        deleteEmployeeRole(Collections.singletonList(param));
    }

    /**
     * 批量员工删除角色
     *
     * @param list EmployeeRoleParam
     */
    public static void deleteEmployeeRole(List<EmployeeRoleParam> list) {
        HttpClientRequestUtils.deleteRequestJson(EMPLOYEE_ROLE_URL, TokenUtils.getToken(), list);
    }

    /**
     * 根据员工id获取员工所属角色信息列表
     *
     * @param id 员工id
     * @return 员工所属的角色信息列表
     */
    public static BaseList<EmployeeRoleInfo> getEmployeeRoleList(String id) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_ROLE_URL, TokenUtils.getToken(), new BaseId(id));
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<EmployeeRoleInfo>>() {
        });
    }

    /**
     * 添加员工的组织机构信息（不带token,取配置文件的服务号信息获取token）
     *
     * @param addEmployeeOrgParam 添加员工组织机构参数
     */
    public static void addEmployeeOrg(AddEmployeeOrgParam addEmployeeOrgParam) {
        addEmployeeOrg(addEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void addEmployeeOrg(AddEmployeeOrgParam addEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, EMPLOYEE_ORG_URL, token, addEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 删除员工组织机构（不带token,取配置文件的服务号信息获取token）
     *
     * @param deleteEmployeeOrgParam 删除员工组织机构参数
     */
    public static void deleteEmployeeOrg(DeleteEmployeeOrgParam deleteEmployeeOrgParam) {
        deleteEmployeeOrg(deleteEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void deleteEmployeeOrg(DeleteEmployeeOrgParam deleteEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.DELETE, EMPLOYEE_ORG_URL, token, deleteEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 更新员工主组织机构
     *
     * @param param EmployeeOrgParam
     */
    public static void updateEmployeeMasterOrg(EmployeeOrgParam param) {
        HttpClientRequestUtils.putRequest(EMPLOYEE_ORG_URL, TokenUtils.getToken(), param);
    }

    /**
     * 编辑员工组织机构状态（不带token,取配置文件的服务号信息获取token）
     *
     * @param editEmployeeOrgParam 编辑员工组织机构状态参数
     */
    public static void editEmployeeOrg(EditEmployeeOrgParam editEmployeeOrgParam) {
        editEmployeeOrg(editEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void editEmployeeOrg(EditEmployeeOrgParam editEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.PUT, EDIT_EMPLOYEE_ORG_STATUS_URL, token, editEmployeeOrgParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 添加员工岗位（不带token,取配置文件的服务号信息获取token）
     *
     * @param addEmployeePositionParam 添加员工岗位参数
     */
    public static void addEmployeePosition(AddEmployeePositionParam addEmployeePositionParam) {
        addEmployeePosition(addEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void addEmployeePosition(AddEmployeePositionParam addEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, ADD_EMPLOYEE_POSITION_URL, token, addEmployeePositionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 删除员工岗位（不带token,取配置文件的服务号信息获取token）
     *
     * @param deleteEmployeePositionParam 删除员工岗位参数
     */
    public static void deleteEmployeePosition(DeleteEmployeePositionParam deleteEmployeePositionParam) {
        deleteEmployeePosition(deleteEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void deleteEmployeePosition(DeleteEmployeePositionParam deleteEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils
            .getBaseHttpVO(HttpRequestTypeEnum.DELETE, DELETE_EMPLOYEE_POSITION_URL, token, deleteEmployeePositionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }


    /**
     * 根据员工工号获取员工信息（不带token,取配置文件的服务号信息获取token）
     *
     * @param employeeNo 员工工号
     * @return 员工信息
     */
    public static BaseData<EmployeeInfo> getEmployeeInfoByEmployeeNo(String employeeNo) {
        return getEmployeeInfoByEmployeeNo(employeeNo, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<EmployeeInfo> getEmployeeInfoByEmployeeNo(String employeeNo, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils
            .getBaseHttpVO(HttpRequestTypeEnum.GET, GET_EMPLOYEE_BY_EMPLOYEE_NO_URL, token, new BaseEmployeeNoParam(employeeNo));
        if (0 == baseHttpVO.getCode()) {
            return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), EmployeeInfo.class));
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 通过工号获取人员基础信息
     *
     * @param param EmployeeNoParam
     * @return List EmployeeUserInfo
     */
    public static List<EmployeeBaseInfo> listByEmployeeNo(EmployeeNoParam param) {
        if (CollectionUtils.isEmpty(param.getEmployeeNoList())) {
            return new ArrayList<>();
        }
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_LIST_NO, TokenUtils.getToken(), param);
        return converterToListBase(vo);
    }

    /**
     * 通过工号获取员工详细信息
     *
     * @param param EmployeeNoParam
     * @return List EmployeeUserInfo
     */
    public static List<EmployeeInfo> listDetailByEmployeeNo(EmployeeNoParam param) {
        if (CollectionUtils.isEmpty(param.getEmployeeNoList())) {
            return new ArrayList<>();
        }
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_LIST_DETAIL_NO, TokenUtils.getToken(), param);
        return converterToListDetail(vo);
    }

    /**
     * 根据员工id获取该员工的权限节点信息列表（不带token,取配置文件的服务号信息获取token）
     *
     * @param employeeId 员工id
     * @return 员工的权限节点信息列表
     */
    public static BaseList<EmployeeAuthInfo> getEmployeeAuthList(String employeeId) {
        return getEmployeeAuthList(employeeId, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeAuthInfo> getEmployeeAuthList(String employeeId, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils
            .getBaseHttpVO(HttpRequestTypeEnum.GET, GET_EMPLOYEE_AUTH_URL, token, new BaseEmployeeIdParam(employeeId));
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<EmployeeAuthInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 注册员工（不带token,取配置文件的服务号信息获取token）
     *
     * @param registerEmployeeParam 注册员工参数
     * @return 新注册员工信息
     */
    public static BaseData<CreateEmployee> registerEmployee(RegisterEmployeeParam registerEmployeeParam) {
        return registerEmployee(registerEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseData<CreateEmployee> registerEmployee(RegisterEmployeeParam registerEmployeeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, REGISTER_EMPLOYEE_URL, token, registerEmployeeParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), CreateEmployee.class));
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 批量创建员工（不带token,取配置文件的服务号信息获取token）
     *
     * @param batchCrateEmployeeParam 批量创建员工参数
     */
    public static void batchCreateEmployee(BatchCrateEmployeeParam batchCrateEmployeeParam) {
        batchCreateEmployee(batchCrateEmployeeParam, TokenUtils.getToken());
    }

    @Deprecated
    public static void batchCreateEmployee(BatchCrateEmployeeParam batchCrateEmployeeParam, String token) {
        HttpClientRequestUtils.postRequestJson(EMPLOYEE_BATCH_URL, token, batchCrateEmployeeParam);
    }

    /**
     * 获取开放服务平台当前团队下的员工列表
     *
     * @param basePageParam 分页请求参数
     * @return 开放平台服务所属的团队下的员工列表
     */
    public static BasePage<EmployeeBaseInfo> pagePartyEmployeeList(BasePageParam basePageParam) {
        return pagePartyEmployeeList(basePageParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pagePartyEmployeeList(BasePageParam basePageParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_EMPLOYEE_BY_PARTY_URL, token, basePageParam);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<EmployeeBaseInfo>>() {
        });
    }

    /**
     * 根据组织机构id分页获取组织机构下的员工信息列表（只获取当前组织机构节点下的）（不带token,取配置文件的服务号信息获取token）
     *
     * @param pageEmployeeOrgParam 根据组织机构id分页获取员工信息列表
     * @return 组织机构下的员工信息列表（只获取当前组织机构节点下的）
     */
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam) {
        return pageEmployeeListByOrgId(pageEmployeeOrgParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_EMPLOYEE_BY_ORG_URL, token, pageEmployeeOrgParam);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<EmployeeBaseInfo>>() {
        });
    }

    /**
     * 根据组织机构id分页获取组织机构下的员工信息列表（包含子组织机构节点下的全部员工信息列表）
     *
     * @param pageEmployeeOrgParam 根据组织机构id分页获取员工信息列表
     * @return 组织机构下的员工信息列表（包含子组织机构节点下的全部员工信息列表）
     */
    public static BasePage<EmployeeBaseInfo> pageEmployeeAllListByOrgId(PageEmployeeOrgParam pageEmployeeOrgParam) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_ALL_EMPLOYEE_BY_ORG_URL, TokenUtils.getToken(), pageEmployeeOrgParam);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<EmployeeBaseInfo>>() {
        });
    }

    /**
     * 获取岗位下的员工列表
     *
     * @param pageEmployeePositionParam 根据岗位id分页获取员工信息列表
     * @return 岗位下的员工信息列表
     */
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByPositionId(PageEmployeePositionParam pageEmployeePositionParam) {
        return pageEmployeeListByPositionId(pageEmployeePositionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByPositionId(PageEmployeePositionParam pageEmployeePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_EMPLOYEE_BY_POSITION_URL, token, pageEmployeePositionParam);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BasePage<EmployeeBaseInfo>>() {
        });
    }

    /**
     * 获取维度下的员工列表
     *
     * @param pageEmployeeDimensionParam 根据维度id分页获取员工信息列表
     * @return 维度下的员工信息列表
     */
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByDimensionId(PageEmployeeDimensionParam pageEmployeeDimensionParam) {
        return pageEmployeeListByDimensionId(pageEmployeeDimensionParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<EmployeeBaseInfo> pageEmployeeListByDimensionId(PageEmployeeDimensionParam pageEmployeeDimensionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(GET_EMPLOYEE_BY_DIMENSION_URL, token, pageEmployeeDimensionParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BasePage<EmployeeBaseInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 根据员工编码获取员工信息
     *
     * @param employeeListByEmpCodesParam employeeListByEmpCodesParam
     * @return 维度下的员工信息列表
     */
    public static BaseList<EmployeeBaseInfo> employeeListByEmpCodes(EmployeeListByEmpCodesParam employeeListByEmpCodesParam) {
        return employeeListByEmpCodes(employeeListByEmpCodesParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BaseList<EmployeeBaseInfo> employeeListByEmpCodes(EmployeeListByEmpCodesParam employeeListByEmpCodesParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, GET_EMPLOYEE_BY_CODE_URL, token, employeeListByEmpCodesParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<EmployeeBaseInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 根据employeeIDList批量查询员工
     *
     * @param param 员工ID集
     * @return EmployeeUserInfo
     */
    public static List<EmployeeBaseInfo> listByEmployeeId(EmployeeIdListParam param) {
        return new ArrayList<>(BaseList.getData(listBaseEmployeeInfoByEmpIDList(param)));
    }

    @Deprecated
    public static BaseList<EmployeeUserInfo> listBaseEmployeeInfoByEmpIDList(EmployeeIdListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_BATCH_URL, TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<EmployeeUserInfo>>() {
        });
    }

    /**
     * 通过员工名模糊分页获取用户
     *
     * @param param BasePageParam
     * @return List EmployeeBaseInfo
     */
    public static BasePage<EmployeeUserInfo> pageLikeName(BasePageParam param) {
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_PAGE_NAME, TokenUtils.getToken(), param);
        return converterToPage(vo);
    }

    /**
     * 通过角色信息获取人员列表
     *
     * @param param EmployeePageRoleIdParam
     * @return List EmployeeBaseInfo
     */
    public static BasePage<EmployeeUserInfo> pageByRole(EmployeePageRoleParam param) {
        if (CollectionUtils.isEmpty(param.getRoleIdList()) && CollectionUtils.isEmpty(param.getRoleCodeList())) {
            return new BasePage<>();
        }
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_PAGE_ROLE, TokenUtils.getToken(), param);
        return converterToPage(vo);
    }

    /**
     * 通过用户id获取用户列表
     *
     * @param param EmployeeListUserIdParam
     * @return List EmployeeUserInfo
     */
    public static List<EmployeeUserInfo> listByUserId(EmployeeListUserIdParam param) {
        if (CollectionUtils.isEmpty(param.getUserIdList())) {
            return new ArrayList<>();
        }
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_LIST_USERID, TokenUtils.getToken(), param);
        return converterToList(vo);
    }

    /**
     * vo 转换为 List EmployeeUserInfo
     *
     * @param vo BaseHttpVO
     * @return List EmployeeUserInfo
     */
    private static List<EmployeeUserInfo> converterToList(BaseHttpVO vo) {
        val type = new TypeReference<BaseList<EmployeeUserInfo>>() {
        };
        val data = HttpClientRequestUtils.convertToData(vo, type);
        return BaseList.getData(data);
    }

    private static List<EmployeeBaseInfo> converterToListBase(BaseHttpVO vo) {
        val type = new TypeReference<BaseList<EmployeeBaseInfo>>() {
        };
        val data = HttpClientRequestUtils.convertToData(vo, type);
        return BaseList.getData(data);
    }

    /**
     * vo 转换为 List EmployeeInfo
     *
     * @param vo BaseHttpVO
     * @return List EmployeeInfo
     */
    private static List<EmployeeInfo> converterToListDetail(BaseHttpVO vo) {
        val type = new TypeReference<BaseList<EmployeeInfo>>() {
        };
        val data = HttpClientRequestUtils.convertToData(vo, type);
        return BaseList.getData(data);
    }

    /**
     * vo 转换为 BasePage EmployeeUserInfo
     *
     * @param vo BaseHttpVO
     * @return BasePage EmployeeUserInfo
     */
    private static BasePage<EmployeeUserInfo> converterToPage(BaseHttpVO vo) {
        val type = new TypeReference<BasePage<EmployeeUserInfo>>() {
        };
        return HttpClientRequestUtils.convertToData(vo, type);
    }

    /**
     * 通过员工id和岗位id查询该用户在该岗位上的岗龄
     *
     * @param param EmployeePositionParam
     * @return 加入时间的毫秒级 | null
     */
    public static Long getAddPositionGmtTime(EmployeePositionParam param) {
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_POSITION_JOIN, TokenUtils.getToken(), param);
        val type = new TypeReference<EmployeePositionDO>() {
        };
        val data = HttpClientRequestUtils.convertToData(vo, type);
        return data == null ? null : data.getGmtCreate();
    }

    /**
     * 根据员工id获取扩展属性
     *
     * @param employeeId 员工id
     * @return List AttributeDetailVO
     */
    public static List<AttributeDetailVO> listAttribute(String employeeId) {
        val param = new IdParam(employeeId);
        val vo = HttpClientRequestUtils.getRequest(EMPLOYEE_LIST_ATTRIBUTE, TokenUtils.getToken(), param);
        val type = new TypeReference<BaseList<AttributeDetailVO>>() {
        };
        val data = HttpClientRequestUtils.convertToData(vo, type);
        return data != null ? data.getList() : new ArrayList<>();
    }

    /**
     * 修改员工扩展属性
     *
     * @param param AttributeParam
     */
    public static void updateAttribute(AttributeParam param) {
        if (CollectionUtils.isEmpty(param.getAttributeMap())) {
            return;
        }
        HttpClientRequestUtils.putRequest(EMPLOYEE_ATTRIBUTE, TokenUtils.getToken(), param);
    }

    /**
     * 新增员工的任职信息
     *
     * @param param BatchTakeOfficeParam
     * @return 该员工的所有任职信息id
     */
    public static List<String> addTakeOfficeByEmpId(BatchTakeOfficeParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.postRequestJson(EMPLOYEE_TAKE_OFFICE_URL, TokenUtils.getToken(), param);
        return Objects.requireNonNull(HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<String>>() {
        })).getList();
    }

    /**
     * 删除员工的任职信息
     *
     * @param param employeeId
     */
    public static void deleteTakeOfficeById(DeleteTakeOfficeParam param) {
        HttpClientRequestUtils.deleteRequest(EMPLOYEE_TAKE_OFFICE_URL, TokenUtils.getToken(), param);
    }

    /**
     * 修改员工的任职信息
     *
     * @param param employeeId
     */
    public static void updateTakeOfficeByEmpId(BatchTakeOfficeParam param) {
        HttpClientRequestUtils.putRequestJson(EMPLOYEE_TAKE_OFFICE_URL, TokenUtils.getToken(), param);
    }

    /**
     * 查询员工的任职信息
     *
     * @param param employeeId
     * @return TakeOfficeInfo
     */
    public static List<TakeOfficeInfo> listTakeOfficeByEmpId(EmployeeIdParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_TAKE_OFFICE_URL, TokenUtils.getToken(), param);
        return Objects.requireNonNull(HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<TakeOfficeInfo>>() {
        })).getList();
    }

    /**
     * 获取某员工的某维度下的组织机构信息
     *
     * @param param EmployeeDimensionParam
     * @return 组织机构消息
     */
    public static List<BaseInfo> listOrgByDimension(EmployeeDimensionParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(EMPLOYEE_DIMENSION_ORG_URL, TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<BaseInfo>>() {
        });
        return BaseList.getData(data);
    }
}