package im.qingtui.qbee.open.platfrom.portal.model.vo.position;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 岗位返回信息
 *
 * @author shizhen
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PositionInfo extends BaseInfo implements Serializable {

    /**
     * 岗位编码
     */
    String code;
    /**
     * 岗位描述
     */
    String desc;
    /**
     * 岗位下的人数
     */
    Integer memberCount;
    /**
     * 岗位所属的组织机构id
     */
    String orgId;
    /**
     * 岗位所属的职务id
     */
    String dutyId;

}