package im.qingtui.qbee.open.platfrom.portal.model.vo.employee;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 员工组织机构返回信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EmployeeOrgInfo implements Serializable {

    /**
     * 员工所属组织机构id
     */
    String id;
    /**
     * 员工所属组织机构的维度id
     */
    String dimensionId;
    /**
     * 是否为主组织机构(0-不是组织机构,1-是主组织机构)
     */
    Integer master;
    /**
     * 员工所在的组织机构权限(0-普通员工,1-负责人,2-主要负责人)
     */
    Integer responsible;
}