package im.qingtui.qbee.open.platfrom.portal.model.vo.employee;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 员工返回信息
 *
 * @author shizhen
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EmployeeInfo implements Serializable {

    /**
     * 员工id
     */
    String id;
    /**
     * 员工名称
     */
    String name;
    /**
     * 员工帐号
     */
    String account;
    /**
     * 员工手机号码
     */
    String mobile;
    /**
     * 员工邮箱
     */
    String email;
    /**
     * 员工头像
     */
    String profile;
    /**
     * 员工性别(1-男,2-女)
     */
    Integer gender;
    /**
     * 员工工号
     */
    String employeeNo;
    /**
     * 员工团队信息
     */
    BaseInfo party;
    /**
     * 员工所属主组织机构信息
     */
    BaseInfo org;
    /**
     * 员工所属岗位信息
     */
    BaseInfo position;
}