package im.qingtui.qbee.open.platfrom.portal.model.param.position;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 分页获取岗位信息列表请求参数
 *
 * @author shizhen
 */
@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PagePositionParam implements Serializable {

    /**
     * 职务id
     */
    String dutyId;
    /**
     * 组织机构id
     */
    String orgId;
    /**
     * 搜索关键字
     */
    String keyword;
    /**
     * 分页大小（最大200）
     */
    Integer size;
    /**
     * 请求页数（从1开始）
     */
    Integer page;
}