package im.qingtui.qbee.open.platfrom.portal.model.param.position;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;

/**
 * 创建岗位请求参数
 *
 * @author shizhen
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@NoArgsConstructor
public class CreatePositionParam implements Serializable {

    /**
     * 岗位名称
     */
    @NonNull
    String name;
    /**
     * 岗位编码
     */
    @NonNull
    String code;
    /**
     * 岗位所属组织机构id
     */
    @NonNull
    String orgId;
    /**
     * 岗位描述
     */
    String desc;
    /**
     * 岗位所属职务id
     */
    String dutyId;
    /**
     * 序列ID
     */
    String sequenceId;
    /**
     * 岗级最小值
     */
    Integer minPositionLevel;
    /**
     * 岗级最大值
     */
    Integer maxPositionLevel;

}