package im.qingtui.qbee.open.platfrom.portal.service;

import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_POSITION_LEVEL_INFO_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_POSITION_LIST_BY_ORG_ID_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_POSITION_LIST_BY_POSITION_CODE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_POSITION_LIST_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.MODIFY_POSITION_LEVEL_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.POSITION_LIST_EMPLOYEE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.POSITION_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseData;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseId;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BasePage;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.model.param.employee.EmployeeIdListParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.CreatePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.EditPositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.ListPositionByCodesParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.ModifyPositionLevelParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.PagePositionBaseParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.PagePositionParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.position.SequenceParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.employee.PositionEmployeeInfo;
import im.qingtui.qbee.open.platfrom.portal.model.vo.position.PositionInfo;
import java.util.List;
import lombok.val;


/**
 * 岗位相关接口
 *
 * @author shizhen
 */
public class PositionService {


    /**
     * 新增岗位
     *
     * @param createPositionParam 创建岗位参数
     * @return 创建的岗位id
     */
    public static BaseData<BaseId> createPosition(CreatePositionParam createPositionParam) {
        return createPosition(createPositionParam, TokenUtils.getToken());
    }

    /**
     * 修改岗位
     *
     * @param editPositionParam 编辑岗位参数
     */
    public static void editPosition(EditPositionParam editPositionParam) {
        editPosition(editPositionParam, TokenUtils.getToken());
    }

    /**
     * 根据岗位id获取岗位信息
     *
     * @param id 岗位id
     * @return 查询的岗位信息
     */
    public static BaseData<PositionInfo> getPositionById(String id) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getApiUrl(POSITION_URL), TokenUtils.getToken(), new BaseId(id));
        return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), PositionInfo.class));
    }

    /**
     * 分页获取岗位信息列表
     *
     * @param pagePositionParam 分页获取岗位信息参数
     * @return 查询的岗位信息列表
     */
    public static BasePage<PositionInfo> pagePositionList(PagePositionParam pagePositionParam) {
        return pagePositionList(pagePositionParam, TokenUtils.getToken());
    }

    /**
     * 根据组织机构id分页获取组织机构下的岗位信息列表
     *
     * @param pagePositionBaseParam 分页获取岗位基础参数
     * @return 组织机构下的岗位信息列表
     */
    public static BasePage<PositionInfo> pagePositionListByOrgId(PagePositionBaseParam pagePositionBaseParam) {
        return pagePositionListByOrgId(pagePositionBaseParam, TokenUtils.getToken());
    }

    /**
     * 通过岗位编码获取岗位信息
     *
     * @param positionByCodesParam positionByCodesParam
     * @return 岗位信息
     */
    public static BaseList<PositionInfo> positionInfoByPositionCode(ListPositionByCodesParam positionByCodesParam) {
        return positionInfoByPositionCode(positionByCodesParam, TokenUtils.getToken());
    }

    @Deprecated
    public static BasePage<PositionInfo> pagePositionList(PagePositionParam pagePositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_POSITION_LIST_URL), token, pagePositionParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BasePage<PositionInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }


    @Deprecated
    public static BaseData<BaseId> createPosition(CreatePositionParam createPositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.POST, UrlUtil.getApiUrl(POSITION_URL), token, createPositionParam);
        if (0 == baseHttpVO.getCode()) {
            return new BaseData<>(JSONObject.parseObject(baseHttpVO.getDataJson().toString(), BaseId.class));
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }


    @Deprecated
    public static void editPosition(EditPositionParam editPositionParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.PUT, UrlUtil.getApiUrl(POSITION_URL), token, editPositionParam);
        if (0 != baseHttpVO.getCode()) {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    @Deprecated
    public static BasePage<PositionInfo> pagePositionListByOrgId(PagePositionBaseParam pagePositionBaseParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_POSITION_LIST_BY_ORG_ID_URL), token, pagePositionBaseParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BasePage<PositionInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }


    @Deprecated
    public static BaseList<PositionInfo> positionInfoByPositionCode(ListPositionByCodesParam positionByCodesParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils
            .getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_POSITION_LIST_BY_POSITION_CODE_URL), token, positionByCodesParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<PositionInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 编辑岗级
     *
     * @param param param
     */
    public static void modifyPositionLevel(ModifyPositionLevelParam param) {
        HttpClientRequestUtils.putRequest(UrlUtil.getApiUrl(MODIFY_POSITION_LEVEL_URL), TokenUtils.getToken(), param);
    }

    /**
     * 根据岗级序号获取岗级信息
     *
     * @param param SequenceParam
     * @return BaseInfo
     */
    public static BaseInfo getPostLevelInfoBySequence(SequenceParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getApiUrl(GET_POSITION_LEVEL_INFO_URL), TokenUtils.getToken(), param);
        return HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseInfo>() {
        });
    }

    /**
     * 根据员工id获取岗位信息
     *
     * @param param 员工id集合
     * @return List PositionEmployeeInfo
     */
    public static List<PositionEmployeeInfo> listByEmployee(EmployeeIdListParam param) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getRequest(UrlUtil.getApiUrl(POSITION_LIST_EMPLOYEE_URL), TokenUtils.getToken(), param);
        val data = HttpClientRequestUtils.convertToData(baseHttpVO, new TypeReference<BaseList<PositionEmployeeInfo>>() {
        });
        return BaseList.getData(data);
    }
}