package im.qingtui.qbee.open.platfrom.portal.service;

import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_AUTH_NODE_BY_MENU_CODE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_AUTH_NODE_BY_MENU_ID_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_AUTH_NODE_LIST_BY_MENU_CODE_URL;
import static im.qingtui.qbee.open.platfrom.portal.model.constant.UrlConstant.GET_AUTH_NODE_LIST_BY_MENU_ID_URL;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import im.qingtui.qbee.open.platfrom.base.common.exception.IllegalRequestException;
import im.qingtui.qbee.open.platfrom.base.common.utils.HttpClientRequestUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.TokenUtils;
import im.qingtui.qbee.open.platfrom.base.common.utils.UrlUtil;
import im.qingtui.qbee.open.platfrom.base.model.enums.HttpRequestTypeEnum;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseHttpVO;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseList;
import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseResult;
import im.qingtui.qbee.open.platfrom.portal.model.param.authnode.ListNodesByMenuCodeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.authnode.ListNodesByMenuIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.menu.MenuCodeParam;
import im.qingtui.qbee.open.platfrom.portal.model.param.menu.MenuIdParam;
import im.qingtui.qbee.open.platfrom.portal.model.vo.authnode.AuthNodeInfo;

/**
 * @author chenmeng(21030135)
 * <p> time: 2021/3/24
 *
 */
@Deprecated
public class AuthNodeService {

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单id获取
     *
     * @param nodesByMenuIdParam nodesByMenuIdParam
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByEmpIdAndMenuId(ListNodesByMenuIdParam nodesByMenuIdParam) {
        return listNodesByEmpIdAndMenuId(nodesByMenuIdParam, TokenUtils.getToken());
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单id获取
     *
     * @param nodesByMenuIdParam nodesByMenuIdParam
     * @param token              开放平台token
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByEmpIdAndMenuId(ListNodesByMenuIdParam nodesByMenuIdParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_AUTH_NODE_BY_MENU_ID_URL), token, nodesByMenuIdParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AuthNodeInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param nodesByMenuCodeParam nodesByMenuCodeParam
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByEmpIdAndMenuCode(ListNodesByMenuCodeParam nodesByMenuCodeParam) {
        return listNodesByEmpIdAndMenuCode(nodesByMenuCodeParam, TokenUtils.getToken());
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param nodesByMenuCodeParam nodesByMenuCodeParam
     * @param token                开放平台token
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByEmpIdAndMenuCode(ListNodesByMenuCodeParam nodesByMenuCodeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getApiUrl(GET_AUTH_NODE_BY_MENU_CODE_URL), token, nodesByMenuCodeParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AuthNodeInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }


    /**
     * 获取菜单（当前菜单节点）下的所有权限节点-菜单id获取
     *
     * @param menuIdParam menuIdParam
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByMenuId(MenuIdParam menuIdParam) {
        return listNodesByMenuId(menuIdParam, TokenUtils.getToken());
    }

    /**
     * 获取菜单（当前菜单节点）下的所有权限节点-菜单id获取
     *
     * @param menuIdParam menuIdParam
     * @param token       开放平台token
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByMenuId(MenuIdParam menuIdParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getFullPath(GET_AUTH_NODE_LIST_BY_MENU_ID_URL), token, menuIdParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AuthNodeInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param menuCodeParam menuCodeParam
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByMenuCode(MenuCodeParam menuCodeParam) {
        return listNodesByMenuCode(menuCodeParam, TokenUtils.getToken());
    }

    /**
     * 获取某用户在某菜单（当前菜单节点）下的所有权限节点-菜单编码获取
     *
     * @param menuCodeParam menuCodeParam
     * @param token         开放平台token
     * @return 权限节点列表
     */
    public static BaseList<AuthNodeInfo> listNodesByMenuCode(MenuCodeParam menuCodeParam, String token) {
        BaseHttpVO baseHttpVO = HttpClientRequestUtils.getBaseHttpVO(HttpRequestTypeEnum.GET, UrlUtil.getFullPath(GET_AUTH_NODE_LIST_BY_MENU_CODE_URL), token, menuCodeParam);
        if (0 == baseHttpVO.getCode()) {
            return JSONObject.parseObject(baseHttpVO.getDataJson().toString(), new TypeReference<BaseList<AuthNodeInfo>>() {
            });
        } else {
            throw new IllegalRequestException(new BaseResult(baseHttpVO));
        }
    }
}
