package im.qingtui.qbee.open.platfrom.portal.model.vo.org;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 组织机构树信息
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class OrgTree implements Serializable {

    /**
     * 组织机构id
     */
    String id;
    /**
     * 组织机构名称
     */
    String name;
    /**
     * 组织机构编码
     */
    String code;
    /**
     * 组织机构下的子节点组织机构列表
     */
    List<OrgTree> children;

    /**
     * 父节点id, 为空表示第一节点
     */
    String parentId;
}