package im.qingtui.qbee.open.platfrom.portal.model.vo.employee;

import im.qingtui.qbee.open.platfrom.base.model.vo.base.BaseInfo;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.FieldDefaults;

/**
 * 员工基础信息
 *
 * @author shizhen
 */
@Data
@EqualsAndHashCode(callSuper = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
@ToString(callSuper = true)
public class EmployeeBaseInfo extends BaseInfo {

    /**
     * 员工头像
     */
    String profile;
    /**
     * 员工工号
     */
    String employeeNo;
    /**
     * 员工编码
     */
    String employeeCode;
    /**
     * 员工性别(1-男,2-女)
     */
    Integer gender;
    /**
     * 员工手机号码
     */
    String mobile;
    /**
     * 员工邮箱
     */
    String email;
    /**
     * 出生日期
     */
    Long gmtBirthday;
    /**
     * 入职日期
     */
    Long gmtEntry;
    /**
     * 第三方系统手机国际码
     */
    String thirdSystemCountryCode;
    /**
     * 第三方系统手机号
     */
    String thirdSystemMobile;
}