package im.qingtui.qbee.open.platfrom.portal.model.param.employee;

import java.io.Serializable;
import java.util.List;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 编辑员工请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EditEmployeeParam implements Serializable {

    /**
     * 员工id
     */
    String id;
    /**
     * 员工名称
     */
    String name;
    /**
     * 员工性别(1-男,2-女)
     */
    Integer gender;
    /**
     * 员工邮箱
     */
    String email;
    /**
     * 员工工号
     */
    String employeeNo;
    /**
     * 员工编码
     */
    String employeeCode;

    /**
     * 员工类型
     */
    String employeeTypeId;

    /**
     * 角色id列表
     */
    @Deprecated
    List<String> roleIdList;
    /**
     * 出生日期
     */
    Long gmtBirthday;
    /**
     * 入职日期
     */
    Long gmtEntry;
    /**
     * 第三方系统手机国际码
     */
    String thirdSystemCountryCode;
    /**
     * 第三方系统手机号
     */
    String thirdSystemMobile;
}