package im.qingtui.qbee.open.platfrom.portal.model.param.employee;

import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 编辑员工组织机构请求参数
 *
 * @author shizhen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class EditEmployeeOrgParam implements Serializable {

    /**
     * 员工id
     */
    String employeeId;
    /**
     * 员工所属组织机构id
     */
    String orgId;
    /**
     * 员工的组织机构权限（0-不是主组织机构，1-是主组织机构）
     */
    Integer master;
    /**
     * 员工在组织机构的权限（0-普通员工，1-负责人，2-主要负责人）
     */
    Integer responsible;
}